/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractFileComplexityDecorator
implements Decorator {
    private Language language;

    public AbstractFileComplexityDecorator(Language language) {
        this.language = language;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return this.language.equals(project.getLanguage());
    }

    @DependsUpon
    public List<Metric> dependsUponFileAndComplexityMetrics() {
        return Arrays.asList(CoreMetrics.FILES, CoreMetrics.COMPLEXITY);
    }

    @DependedUpon
    public Metric generateFileComplexityMetric() {
        return CoreMetrics.FILE_COMPLEXITY;
    }

    @Override
    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource, context)) {
            return;
        }
        Double files = MeasureUtils.getValue(context.getMeasure(CoreMetrics.FILES), null);
        Double complexity = MeasureUtils.getValue(context.getMeasure(CoreMetrics.COMPLEXITY), null);
        if (complexity != null && files != null && files > 0.0) {
            context.saveMeasure(CoreMetrics.FILE_COMPLEXITY, complexity / files);
        }
    }

    private boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return !MeasureUtils.hasValue(context.getMeasure(CoreMetrics.FILE_COMPLEXITY)) && !ResourceUtils.isEntity(resource);
    }
}

