/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.rules.RulePriority;

@Entity
@Table(name="rule_failures")
public class RuleFailureModel
extends BaseIdentifiable {
    public static final int MESSAGE_COLUMN_SIZE = 4000;
    @Column(name="snapshot_id")
    protected Integer snapshotId;
    @Column(name="rule_id", updatable=false, nullable=false)
    private Integer ruleId;
    @Column(name="failure_level", updatable=true, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority priority;
    @Column(name="message", updatable=false, nullable=true, length=4000)
    private String message;
    @Column(name="line", updatable=true, nullable=true)
    private Integer line;
    @Column(name="cost", updatable=true, nullable=true)
    private Double cost;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @Column(name="checksum", updatable=true, nullable=true, length=1000)
    private String checksum;
    @Column(name="permanent_id", updatable=true, nullable=true)
    private Integer permanentId;
    @Column(name="switched_off", updatable=true, nullable=true)
    private Boolean switchedOff = Boolean.FALSE;
    @Column(name="committer", updatable=true, nullable=true, length=100)
    private String committer;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = RuleFailureModel.abbreviateMessage(message);
    }

    public static String abbreviateMessage(String message) {
        return StringUtils.abbreviate((String)StringUtils.trim((String)message), (int)4000);
    }

    @Deprecated
    public RulePriority getLevel() {
        return this.priority;
    }

    @Deprecated
    public void setLevel(RulePriority priority) {
        this.priority = priority;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
    }

    public Integer getLine() {
        return this.line;
    }

    public RulePriority getPriority() {
        return this.priority;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Integer i) {
        this.snapshotId = i;
    }

    public void setPriority(RulePriority priority) {
        this.priority = priority;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public Double getCost() {
        return this.cost;
    }

    public RuleFailureModel setCost(Double d) {
        this.cost = d;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Integer getPermanentId() {
        return this.permanentId;
    }

    public RuleFailureModel setPermanentId(Integer i) {
        this.permanentId = i;
        return this;
    }

    public boolean isSwitchedOff() {
        return this.switchedOff != null && this.switchedOff != false;
    }

    public RuleFailureModel setSwitchedOff(boolean b) {
        this.switchedOff = b;
        return this;
    }

    public String getCommitter() {
        return this.committer;
    }

    public RuleFailureModel setCommitter(String committer) {
        this.committer = committer;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleFailureModel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleFailureModel other = (RuleFailureModel)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

