/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckFactory<CHECK> {
    private Map<ActiveRule, CHECK> checkByActiveRule = Maps.newIdentityHashMap();
    private Map<CHECK, ActiveRule> activeRuleByCheck = Maps.newIdentityHashMap();
    private RulesProfile profile;
    private String repositoryKey;

    protected CheckFactory(RulesProfile profile, String repositoryKey) {
        this.repositoryKey = repositoryKey;
        this.profile = profile;
    }

    protected void init() {
        this.checkByActiveRule.clear();
        this.activeRuleByCheck.clear();
        for (ActiveRule activeRule : this.profile.getActiveRulesByRepository(this.repositoryKey)) {
            CHECK check = this.createCheck(activeRule);
            this.checkByActiveRule.put(activeRule, check);
            this.activeRuleByCheck.put(check, activeRule);
        }
    }

    abstract CHECK createCheck(ActiveRule var1);

    public final String getRepositoryKey() {
        return this.repositoryKey;
    }

    public final Collection<CHECK> getChecks() {
        return this.checkByActiveRule.values();
    }

    public final CHECK getCheck(ActiveRule activeRule) {
        return this.checkByActiveRule.get(activeRule);
    }

    public final ActiveRule getActiveRule(CHECK check) {
        return this.activeRuleByCheck.get(check);
    }
}

