/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xmlbeans.impl.tool.SchemaCompiler;
import org.codehaus.mojo.xmlbeans.ParameterAdapter;
import org.codehaus.mojo.xmlbeans.PluginProperties;
import org.codehaus.mojo.xmlbeans.SchemaArtifact;
import org.codehaus.mojo.xmlbeans.SchemaArtifactLookup;
import org.codehaus.mojo.xmlbeans.XmlBeansException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.EntityResolver;

public abstract class AbstractXmlBeansPlugin
extends AbstractMojo
implements PluginProperties {
    private File outputJar;
    private boolean download;
    private boolean debug;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private String compiler;
    private boolean verbose;
    private boolean quiet = true;
    private boolean noUpa;
    private boolean noPvr;
    private boolean jaxb;
    private boolean noJavac;
    private boolean noAnn;
    private boolean noVDoc;
    protected File catalogLocation;
    private List sourceSchemas;
    private List xmlConfigs;
    private String javaSource;
    private Map artifactMap;
    protected MavenProject project;
    private EntityResolver entityResolver = null;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private File[] xsdFiles;
    private File[] wsdlFiles;

    public final void execute() throws MojoExecutionException {
        if (this.hasSchemas()) {
            try {
                SchemaCompiler.Parameters compilerParams = ParameterAdapter.getCompilerParameters(this);
                if (this.isOutputStale()) {
                    try {
                        compilerParams.getSrcDir().mkdirs();
                        boolean result = SchemaCompiler.compile((SchemaCompiler.Parameters)compilerParams);
                        if (!result) {
                            StringBuffer errors = new StringBuffer();
                            Iterator iterator = compilerParams.getErrorListener().iterator();
                            while (iterator.hasNext()) {
                                Object o = iterator.next();
                                errors.append("xml Error").append(o);
                                errors.append("\n");
                            }
                            throw new XmlBeansException(XmlBeansException.COMPILE_ERRORS, errors.toString());
                        }
                        this.touchStaleFile();
                    }
                    catch (IOException ioe) {
                        throw new XmlBeansException(XmlBeansException.STALE_FILE_TOUCH, this.getStaleFile().getAbsolutePath(), (Throwable)ioe);
                    }
                    this.updateProject(this.project, compilerParams);
                }
                this.getLog().info((CharSequence)"All schema objects are up to date.");
            }
            catch (DependencyResolutionRequiredException drre) {
                throw new XmlBeansException(XmlBeansException.CLASSPATH_DEPENDENCY, drre);
            }
        } else {
            this.getLog().info((CharSequence)"Nothing to generate.");
        }
    }

    private boolean hasSchemas() throws XmlBeansException {
        int xsds = this.getXsdFiles().length;
        int wsdls = this.getWsdlFiles().length;
        this.getLog().debug((CharSequence)("Number of XSD Files: " + xsds));
        this.getLog().debug((CharSequence)("Number of WSDL Files: " + wsdls));
        return xsds > 0 || wsdls > 0;
    }

    protected abstract void updateProject(MavenProject var1, SchemaCompiler.Parameters var2) throws DependencyResolutionRequiredException, XmlBeansException;

    protected abstract List getXsdJars();

    protected abstract File getGeneratedSchemaDirectory();

    private void touchStaleFile() throws IOException {
        File staleFile = this.getStaleFile();
        if (!staleFile.exists()) {
            staleFile.getParentFile().mkdirs();
            staleFile.createNewFile();
            this.getLog().debug((CharSequence)"Stale flag file created.");
        } else {
            staleFile.setLastModified(System.currentTimeMillis());
        }
    }

    private boolean isOutputStale() throws XmlBeansException {
        boolean stale;
        File staleFile = this.getStaleFile();
        boolean bl = stale = !staleFile.exists();
        if (!stale) {
            this.getLog().debug((CharSequence)"Stale flag file exists.");
            long staleMod = staleFile.lastModified();
            this.getLog().debug((CharSequence)"Comparing to xsd's modification time.");
            File[] sourceXsds = this.getXsdFiles();
            int fileCount = sourceXsds.length;
            this.getLog().debug((CharSequence)(fileCount + " xsd to compare."));
            for (int i = 0; i < fileCount; ++i) {
                if (sourceXsds[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceXsds[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
            this.getLog().debug((CharSequence)"Comparing to wsdl's modification time.");
            File[] sourceWsdls = this.getWsdlFiles();
            fileCount = sourceWsdls.length;
            this.getLog().debug((CharSequence)(fileCount + " wsdl to compare."));
            for (int i = 0; i < fileCount; ++i) {
                if (sourceWsdls[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceWsdls[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    public abstract File getBaseDir();

    public abstract File getStaleFile();

    public abstract File getDefaultXmlConfigDir();

    public abstract File getSchemaDirectory();

    public final File[] getClasspath() throws DependencyResolutionRequiredException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator i = this.project.getCompileClasspathElements().iterator();
        while (i.hasNext()) {
            results.add(new File((String)i.next()));
        }
        return results.toArray(EMPTY_FILE_ARRAY);
    }

    public final String getCompiler() {
        return this.compiler;
    }

    public final File[] getConfigFiles() throws XmlBeansException {
        File defaultXmlConfigDir = this.getDefaultXmlConfigDir();
        this.getLog().debug((CharSequence)"Creating a list of config files.");
        try {
            if (this.xmlConfigs != null) {
                return this.getFileList(this.xmlConfigs).toArray(new File[0]);
            }
            if (defaultXmlConfigDir.exists()) {
                this.getLog().debug((CharSequence)("Examining " + defaultXmlConfigDir + " for config files."));
                ArrayList<File> defaultDir = new ArrayList<File>();
                defaultDir.add(defaultXmlConfigDir);
                return this.getFileList(defaultDir).toArray(new File[0]);
            }
            return null;
        }
        catch (XmlBeansException xmlbe) {
            throw new XmlBeansException(XmlBeansException.INVALID_CONFIG_FILE, (Throwable)((Object)xmlbe));
        }
    }

    private final List getFileList(List fileList) throws XmlBeansException {
        if (fileList != null) {
            this.getLog().debug((CharSequence)"A list was given.");
            ArrayList<File> files = new ArrayList<File>();
            File nextFile = null;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setCaseSensitive(false);
            scanner.addDefaultExcludes();
            Iterator iterator = fileList.iterator();
            while (iterator.hasNext()) {
                nextFile = (File)iterator.next();
                if (nextFile.exists()) {
                    if (nextFile.isDirectory()) {
                        scanner.setBasedir(nextFile);
                        scanner.scan();
                        String[] fileArray = scanner.getIncludedFiles();
                        if (fileArray == null) continue;
                        for (int i = 0; i < fileArray.length; ++i) {
                            this.getLog().debug((CharSequence)("Adding " + fileArray[i]));
                            files.add(new File(nextFile, fileArray[i]));
                        }
                        continue;
                    }
                    files.add(nextFile);
                    continue;
                }
                throw new XmlBeansException(XmlBeansException.MISSING_FILE, nextFile.getAbsolutePath());
            }
            return files;
        }
        this.getLog().debug((CharSequence)"No list was given. Returning.");
        return null;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final Collection getErrorListeners() {
        ArrayList listener = new ArrayList();
        return listener;
    }

    public final List getExtensions() {
        return null;
    }

    final void setProject(MavenProject project) {
        this.project = project;
    }

    public final File[] getJavaFiles() {
        return new File[0];
    }

    public final Set getMdefNamespaces() {
        return null;
    }

    public final String getJavaSource() {
        return this.javaSource;
    }

    public final String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public final String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public final String getName() {
        return null;
    }

    public final File getOutputJar() {
        if (this.outputJar != null) {
            this.outputJar.getParentFile().mkdirs();
        }
        return this.outputJar;
    }

    public final String getRepackage() {
        return null;
    }

    public final boolean hasCatalogFile() {
        this.getLog().debug((CharSequence)("looking for resolver catalog at " + this.catalogLocation.getAbsolutePath()));
        return this.catalogLocation.exists();
    }

    public final String getCatalogFile() {
        this.getLog().debug((CharSequence)"Using resolver catalog.");
        return this.catalogLocation.getAbsolutePath();
    }

    public final File[] getXsdFiles() throws XmlBeansException {
        this.xsdFiles = this.getFiles(this.xsdFiles, "**/*.xsd");
        return this.xsdFiles;
    }

    public final File[] getWsdlFiles() throws XmlBeansException {
        this.wsdlFiles = this.getFiles(this.wsdlFiles, "**/*.wsdl");
        return this.wsdlFiles;
    }

    private File[] getFiles(File[] schemaFiles, String includeFilter) throws XmlBeansException {
        File[] results = schemaFiles;
        if (schemaFiles == null) {
            File schemaDirectory = this.getSchemaDirectory();
            this.getLog().debug((CharSequence)("The schema Directory is " + schemaDirectory));
            ArrayList<File> schemas = new ArrayList<File>();
            Map artifactSchemas = this.getArtifactSchemas();
            if (this.sourceSchemas != null) {
                File nextFile = null;
                Iterator iterator = this.sourceSchemas.iterator();
                while (iterator.hasNext()) {
                    String schemaName = (String)iterator.next();
                    String ext = FileUtils.getExtension((String)schemaName);
                    if (!includeFilter.endsWith(ext)) continue;
                    nextFile = new File(schemaDirectory, schemaName);
                    if (nextFile.exists()) {
                        schemas.add(nextFile);
                        continue;
                    }
                    if (artifactSchemas.containsKey(schemaName)) {
                        schemas.add((File)artifactSchemas.get(schemaName));
                        continue;
                    }
                    String[] fields = new String[]{schemaName, schemaDirectory.getAbsolutePath()};
                    fields[3] = this.artifactMap.isEmpty() ? "" : " or the schema artifact(s)";
                    throw new XmlBeansException(XmlBeansException.MISSING_SCHEMA_FILE, fields);
                }
            } else if (schemaDirectory.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(schemaDirectory);
                this.getLog().debug((CharSequence)("Scanning for " + includeFilter));
                String[] includes = new String[]{includeFilter};
                scanner.setIncludes(includes);
                scanner.addDefaultExcludes();
                scanner.setCaseSensitive(false);
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        this.getLog().debug((CharSequence)("Adding " + files[i]));
                        schemas.add(new File(schemaDirectory, files[i]));
                    }
                }
            }
            results = schemas.toArray(new File[0]);
        }
        return results;
    }

    private Map getArtifactSchemas() throws XmlBeansException {
        this.getLog().debug((CharSequence)("Artifact count: " + this.artifactMap.size()));
        SchemaArtifactLookup lookup = new SchemaArtifactLookup(this.artifactMap, this.getLog());
        HashMap artifactSchemas = new HashMap();
        List xsdJars = this.getXsdJars();
        File prefix = this.getGeneratedSchemaDirectory();
        int count = xsdJars.size();
        Artifact nextArtifact = null;
        this.getLog().debug((CharSequence)"looking for artifact schemas.");
        for (int i = 0; i < count; ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("resolving " + xsdJars.get(i) + " into a file path."));
            }
            nextArtifact = lookup.find((String)xsdJars.get(i));
            artifactSchemas.putAll(SchemaArtifact.getFilePaths(nextArtifact, this.getLog(), prefix));
        }
        return artifactSchemas;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final boolean isDownload() {
        return this.download;
    }

    public final boolean isJaxb() {
        return this.jaxb;
    }

    public final boolean isNoAnn() {
        return this.noAnn;
    }

    public final boolean isNoVDoc() {
        return this.noVDoc;
    }

    public final boolean isNoJavac() {
        return this.noJavac;
    }

    public final boolean isNoPvr() {
        return this.noPvr;
    }

    public final boolean isNoUpa() {
        return this.noUpa;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void validate() throws XmlBeansException {
    }
}

