/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Plugin;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.DependencyUpdatesXmlRenderer;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.utils.PluginComparator;

public class PluginUpdatesXmlRenderer {
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String OPEN_TAG = "<";
    private static final String CLOSE_TAG = ">";
    private static final String OPEN_CLOSING_TAG = "</";
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private Map<Plugin, PluginUpdatesDetails> pluginUpdates;
    private Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates;
    private String outputFileName;

    public PluginUpdatesXmlRenderer(Map<Plugin, PluginUpdatesDetails> pluginUpdates, Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates, String outputFileName) {
        this.pluginUpdates = pluginUpdates;
        this.pluginManagementUpdates = pluginManagementUpdates;
        this.outputFileName = outputFileName;
    }

    public void render() throws MavenReportException {
        StringBuilder sb = new StringBuilder();
        sb.append("<PluginUpdatesReport>").append(NL);
        TreeMap<Plugin, PluginUpdatesDetails> allUpdates = new TreeMap<Plugin, PluginUpdatesDetails>(new PluginComparator());
        allUpdates.putAll(this.pluginManagementUpdates);
        allUpdates.putAll(this.pluginUpdates);
        sb.append(PluginUpdatesXmlRenderer.getSummaryBlock(allUpdates));
        sb.append(PluginUpdatesXmlRenderer.getPluginsInfoBlock(this.pluginManagementUpdates, "pluginManagements", "pluginManagement"));
        sb.append(PluginUpdatesXmlRenderer.getPluginsInfoBlock(this.pluginUpdates, "plugins", "plugin"));
        sb.append("</PluginUpdatesReport>").append(NL);
        try {
            PrintWriter pw = new PrintWriter(this.outputFileName, "UTF8");
            pw.print(sb.toString());
            pw.close();
        }
        catch (IOException e) {
            throw new MavenReportException("Cannot create xml report.", (Exception)e);
        }
    }

    private static String getSummaryBlock(Map<Plugin, PluginUpdatesDetails> allUpdates) {
        ArrayList<ArtifactVersions> allVersions = new ArrayList<ArtifactVersions>();
        for (PluginUpdatesDetails details : allUpdates.values()) {
            allVersions.add(details.getArtifactVersions());
        }
        return DependencyUpdatesXmlRenderer.getSummaryBlock(allVersions);
    }

    private static String getPluginsInfoBlock(Map<Plugin, PluginUpdatesDetails> pluginUpdates, String blockName, String subblockName) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(TAB).append(OPEN_TAG).append(blockName).append(CLOSE_TAG).append(NL);
        for (Map.Entry<Plugin, PluginUpdatesDetails> entry : pluginUpdates.entrySet()) {
            sBuilder.append(TAB).append(TAB).append(OPEN_TAG).append(subblockName).append(CLOSE_TAG).append(NL);
            Plugin plugin = entry.getKey();
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(plugin.getGroupId(), GROUP_ID)).append(NL);
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(plugin.getArtifactId(), ARTIFACT_ID)).append(NL);
            sBuilder.append(DependencyUpdatesXmlRenderer.getVersionsBlocks(entry.getValue().getArtifactVersions()));
            sBuilder.append(TAB).append(TAB).append(OPEN_CLOSING_TAG).append(subblockName).append(CLOSE_TAG).append(NL);
        }
        sBuilder.append(TAB).append(OPEN_CLOSING_TAG).append(blockName).append(CLOSE_TAG).append(NL);
        return sBuilder.toString();
    }
}

