/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.ounce.AbstractOunceMojo;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.utils.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class ProjectOnlyMojo
extends AbstractOunceMojo {
    public static final String PATH_SEPARATOR = ";";
    public static final String M2_REPO = "M2_REPO";
    private String classpathScope;
    private String jdkName;
    private String javaCompilerOptions;
    protected boolean includeTestSources;
    protected boolean createVariables;
    String installDir;
    private String webappDirectory;
    private boolean analyzeStrutsFramework;
    private boolean importStrutsValidation;
    protected ArtifactRepository local;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging() != "pom" || !this.skipPoms) {
            try {
                String classPath = this.buildClasspath();
                List sourceRoots = this.getSourceRoots();
                String projectRoot = this.getProjectRoot();
                this.webappDirectory = Utils.convertToRelativePath(this.webappDirectory, projectRoot, "");
                classPath = Utils.convertToRelativePath(classPath, projectRoot, "");
                classPath = Utils.convertToRelativePath(classPath, this.local.getBasedir(), M2_REPO);
                classPath = Utils.convertToVariablePath(classPath, this.pathVariableMap);
                sourceRoots = Utils.convertToRelativePaths(sourceRoots, projectRoot, "");
                projectRoot = ".";
                OunceCore core = this.getCore();
                core.createProject(this.getProjectRoot(), this.name, projectRoot, sourceRoots, this.webappDirectory, classPath, this.jdkName, this.javaCompilerOptions, this.project.getPackaging(), this.options, this.analyzeStrutsFramework, this.importStrutsValidation, this.getLog());
                if (!this.createVariables) return;
                if (this.pathVariableMap == null) {
                    this.pathVariableMap = new HashMap();
                }
                if (this.pathVariableMap.get(M2_REPO) == null) {
                    this.pathVariableMap.put(M2_REPO, this.local.getBasedir());
                }
                core.createPathVariables(this.pathVariableMap, this.installDir, this.getLog());
                return;
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Unable to lookup the core interface for hint: " + this.coreHint, (Exception)((Object)e));
            }
            catch (OunceCoreException e) {
                throw new MojoExecutionException("Nested Ouncecore exception: " + e.getLocalizedMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Pom project.");
        }
    }

    protected List getSourceRoots() {
        List sourceRoots = this.project.getCompileSourceRoots();
        if (this.includeTestSources) {
            sourceRoots.addAll(this.project.getTestCompileSourceRoots());
        }
        return sourceRoots;
    }

    protected String buildClasspath() throws MojoExecutionException {
        List classpathElements = this.getClasspathElements();
        StringBuffer sb = new StringBuffer();
        Iterator i = classpathElements.iterator();
        if (i.hasNext()) {
            sb.append(Utils.convertToUnixStylePath((String)i.next()));
            while (i.hasNext()) {
                sb.append(PATH_SEPARATOR);
                sb.append(Utils.convertToUnixStylePath((String)i.next()));
            }
        }
        return sb.toString();
    }

    protected List getClasspathElements() throws MojoExecutionException {
        List classpathElements;
        block6: {
            classpathElements = null;
            try {
                if ("test".equalsIgnoreCase(this.classpathScope) || this.includeTestSources) {
                    classpathElements = this.project.getTestClasspathElements();
                    break block6;
                }
                if ("compile".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getCompileClasspathElements();
                    break block6;
                }
                if ("runtime".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getRuntimeClasspathElements();
                    break block6;
                }
                if ("system".equalsIgnoreCase(this.classpathScope)) {
                    classpathElements = this.project.getSystemClasspathElements();
                    break block6;
                }
                throw new MojoExecutionException("Invalid classpathScope: " + this.classpathScope + " valid values are: compile, test, runtime, system.");
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
        }
        return classpathElements;
    }

    protected String getClasspathScope() {
        return this.classpathScope;
    }

    protected void setClasspathScope(String theClasspathScope) {
        this.classpathScope = theClasspathScope;
    }

    protected String getJdkName() {
        return this.jdkName;
    }

    protected void setJdkName(String theJdkName) {
        this.jdkName = theJdkName;
    }

    protected boolean isIncludeTestSources() {
        return this.includeTestSources;
    }

    protected void setIncludeTestSources(boolean theIncludeTestSources) {
        this.includeTestSources = theIncludeTestSources;
    }

    protected String getJavaCompilerOptions() {
        return this.javaCompilerOptions;
    }

    protected void setJavaCompilerOptions(String theJavaCompilerOptions) {
        this.javaCompilerOptions = theJavaCompilerOptions;
    }

    protected String getWebappDirectory() {
        return this.webappDirectory;
    }

    protected void setWebappDirectory(String theWebappDirectory) {
        this.webappDirectory = theWebappDirectory;
    }

    protected boolean getAnalyzeStrutsFramework() {
        return this.analyzeStrutsFramework;
    }

    protected void setAnalyzeStrutsFramework(boolean analyzeStrutsFramework) {
        this.analyzeStrutsFramework = analyzeStrutsFramework;
    }

    protected boolean getImportStrutsValidation() {
        return this.importStrutsValidation;
    }

    protected void setImportStrutsValidation(boolean importStrutsValidation) {
        this.importStrutsValidation = importStrutsValidation;
    }

    public ArtifactRepository getLocal() {
        return this.local;
    }

    public void setLocal(ArtifactRepository theLocal) {
        this.local = theLocal;
    }
}

