/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.Date;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class SurefireReportBean
extends AbstractReportBean {
    private int nbTests;
    private int nbErrors;
    private int nbFailures;
    private int nbSkipped;
    private double sucessRate;
    private double elapsedTime;
    private static final int PCENT = 100;

    public SurefireReportBean() {
    }

    public SurefireReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public double getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(double elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    public void setNbErrors(int nbErrors) {
        this.nbErrors = nbErrors;
    }

    public int getNbFailures() {
        return this.nbFailures;
    }

    public void setNbFailures(int nbFailures) {
        this.nbFailures = nbFailures;
    }

    public int getNbSkipped() {
        return this.nbSkipped;
    }

    public void setNbSkipped(int nbSkipped) {
        this.nbSkipped = nbSkipped;
    }

    public int getNbTests() {
        return this.nbTests;
    }

    public void setNbTests(int nbTests) {
        this.nbTests = nbTests;
    }

    public double getSucessRate() {
        return this.sucessRate;
    }

    public void setSucessRate(double sucessRate) {
        this.sucessRate = sucessRate;
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof SurefireReportBean) {
            this.nbTests += ((SurefireReportBean)dashboardReport).getNbTests();
            this.nbErrors += ((SurefireReportBean)dashboardReport).getNbErrors();
            this.nbFailures += ((SurefireReportBean)dashboardReport).getNbFailures();
            this.nbSkipped += ((SurefireReportBean)dashboardReport).getNbSkipped();
            this.elapsedTime += ((SurefireReportBean)dashboardReport).getElapsedTime();
            if (this.nbTests == 0) {
                this.sucessRate = 0.0;
            } else {
                double success = this.nbTests - this.nbErrors - this.nbFailures - this.nbSkipped;
                this.sucessRate = success / (double)this.nbTests * 100.0;
            }
        }
    }
}

