/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.dashboard.report.plugin.AbstractDashBoardMojo;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardUtils;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.hibernate.Query;

public class DashBoardDBMojo
extends AbstractDashBoardMojo {
    private Date generatedDate;
    private boolean isPropHibernateSet = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean persistDB = this.canPersistDB();
        boolean recursive = this.isRecursive();
        if (recursive) {
            this.dashBoardUtils = DashBoardUtils.getInstance(this.getLog(), this.mavenProjectBuilder, this.localRepository, true);
            this.generatedDate = new Date(System.currentTimeMillis());
            DashBoardMavenProject mavenProject = this.dashBoardUtils.getDashBoardMavenProject(this.project, this.dashboardDataFile, this.generatedDate);
            this.dashBoardUtils.saveXMLDashBoardReport(this.project, mavenProject, this.dashboardDataFile);
            if (persistDB) {
                this.configureHibernateDriver();
                long start = System.currentTimeMillis();
                this.getLog().info((CharSequence)("DashBoardDBMojo project = " + this.project.getName()));
                this.getLog().info((CharSequence)("DashBoardDBMojo nb modules = " + this.project.getModules().size()));
                this.getLog().info((CharSequence)("DashBoardDBMojo is root = " + this.project.isExecutionRoot()));
                this.getLog().info((CharSequence)("DashBoardDBMojo base directory = " + this.project.getBasedir()));
                this.getLog().info((CharSequence)("DashBoardDBMojo output directory = " + this.outputDirectory));
                this.getLog().info((CharSequence)("DashBoardDBMojo project language = " + this.project.getArtifact().getArtifactHandler().getLanguage()));
                this.refactorMavenProject(mavenProject);
                this.hibernateService.saveOrUpdate(mavenProject);
                long end = System.currentTimeMillis();
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS", Locale.getDefault());
                this.getLog().info((CharSequence)("DashBoardDBMojo save Dashboard elapsed time = " + formatter.format(new Date(end - start))));
            }
        }
    }

    private boolean canPersistDB() {
        boolean persist = false;
        boolean recursive = this.isRecursive();
        boolean root = this.project.isExecutionRoot();
        this.isPropHibernateSet = this.isDBAvailable();
        if (recursive && root && this.isPropHibernateSet) {
            persist = true;
        } else {
            if (!root) {
                this.getLog().warn((CharSequence)"DashBoardDBMojo: Not root project - skipping persist goal.");
            }
            if (!this.isPropHibernateSet) {
                this.getLog().warn((CharSequence)"DashBoardDBMojo: Hibernate properties not set - skipping persist goal.");
            }
        }
        return persist;
    }

    private boolean isRecursive() {
        boolean recursive;
        boolean bl = recursive = this.project.getCollectedProjects().size() >= this.project.getModules().size();
        if (!recursive) {
            this.getLog().warn((CharSequence)"DashBoardDBMojo: Not recursive into sub-projects - skipping XML generation.");
        }
        return recursive;
    }

    private void refactorMavenProject(DashBoardMavenProject mavenProject) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("select m.id from DashBoardMavenProject m where ");
        queryString.append("m.artifactId = :artifactid ");
        queryString.append("and m.groupId = :groupid ");
        queryString.append("and m.version = :version ");
        Query query = this.hibernateService.getSession().getNamedQuery("org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject.getDashBoardMavenProjectID");
        query.setParameter("artifactid", (Object)mavenProject.getArtifactId());
        query.setParameter("groupid", (Object)mavenProject.getGroupId());
        query.setParameter("version", (Object)mavenProject.getVersion());
        List result = query.list();
        if (result != null && !result.isEmpty()) {
            long id = (Long)result.get(0);
            mavenProject.setId(id);
        }
        Set reports = mavenProject.getReports();
        Iterator iter = reports.iterator();
        while (iter.hasNext()) {
            AbstractReportBean report = (AbstractReportBean)iter.next();
            if (report == null) continue;
            report.setMavenProject(mavenProject);
        }
        Set modules = mavenProject.getModules();
        Iterator iterModule = modules.iterator();
        while (iterModule.hasNext()) {
            DashBoardMavenProject project = (DashBoardMavenProject)iterModule.next();
            this.refactorMavenProject(project);
        }
    }
}

