/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.configuration;

import java.util.Map;

public class MaxHeapSizeUtil {
    public static final String MAVEN_OPTIONS = "MAVEN_OPTS";
    public static final String MAX_MEMORY_FLAG = "-Xmx";
    private static final int NUMBER_OF_FLAG_CHARS = "-Xmx".length();
    private static MaxHeapSizeUtil maxHeapSizeUtil;
    private Map envSettings;

    public static MaxHeapSizeUtil getInstance() {
        if (maxHeapSizeUtil == null) {
            maxHeapSizeUtil = new MaxHeapSizeUtil();
        }
        return maxHeapSizeUtil;
    }

    private MaxHeapSizeUtil() {
    }

    private Map getEnvSettings() {
        if (this.envSettings == null) {
            this.envSettings = System.getenv();
        }
        return this.envSettings;
    }

    public void setEnvSettings(Map envSettings) {
        this.envSettings = envSettings;
    }

    public String getMavenMaxMemSetting() {
        String maxMemSetting;
        int startIndex;
        boolean hasMavenOptions = this.getEnvSettings().containsKey(MAVEN_OPTIONS);
        if (!hasMavenOptions) {
            return null;
        }
        String mavenOpts = (String)this.getEnvSettings().get(MAVEN_OPTIONS);
        boolean hasMaxMemSetting = mavenOpts.contains(MAX_MEMORY_FLAG);
        if (!hasMaxMemSetting) {
            return null;
        }
        String mavenOptionsEnvironmentSetting = (String)this.getEnvSettings().get(MAVEN_OPTIONS);
        int endIndex = mavenOptionsEnvironmentSetting.indexOf(32, startIndex = mavenOptionsEnvironmentSetting.indexOf(MAX_MEMORY_FLAG) + NUMBER_OF_FLAG_CHARS);
        if (endIndex == -1) {
            endIndex = mavenOptionsEnvironmentSetting.length();
        }
        if (!(maxMemSetting = mavenOptionsEnvironmentSetting.substring(startIndex, endIndex).trim()).matches("\\d+[mgMG]")) {
            return null;
        }
        return maxMemSetting;
    }

    public boolean envHasMavenMaxMemSetting() {
        return this.getMavenMaxMemSetting() != null;
    }
}

