/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml;

import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.AbstractJavaModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugins.xml.XmlModelHelpers;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;

public abstract class AbstractXmlJavaGenerator
extends AbstractJavaModelloGenerator {
    protected String getFileName(String suffix) {
        String name = this.getModel().getName();
        return name + suffix;
    }

    protected String resolveTagName(ModelClass modelClass) {
        return XmlModelHelpers.resolveTagName(modelClass);
    }

    protected String resolveTagName(ModelField modelField, XmlFieldMetadata xmlFieldMetadata) {
        return XmlModelHelpers.resolveTagName(modelField, xmlFieldMetadata);
    }

    protected String resolveTagName(String fieldTagName, XmlAssociationMetadata xmlAssociationMetadata) {
        return XmlModelHelpers.resolveTagName(fieldTagName, xmlAssociationMetadata);
    }

    protected String getValue(String type, String initialValue, XmlFieldMetadata xmlFieldMetadata) {
        String textValue = initialValue;
        if ("Date".equals(type)) {
            String dateFormat = xmlFieldMetadata.getFormat();
            if (xmlFieldMetadata.getFormat() == null) {
                dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            textValue = "new java.text.SimpleDateFormat( \"" + dateFormat + "\", Locale.US ).format( " + textValue + " )";
        } else if (!"String".equals(type)) {
            textValue = "String.valueOf( " + textValue + " )";
        }
        return textValue;
    }

    protected void writeDateParsingHelper(JSourceCode sc, String exception) {
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("String effectiveDateFormat = dateFormat;");
        sc.add("if ( dateFormat == null )");
        sc.add("{");
        sc.addIndented("effectiveDateFormat = \"yyyy-MM-dd'T'HH:mm:ss.SSS\";");
        sc.add("}");
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, Locale.US );");
        sc.add("return dateParser.parse( s );");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( java.text.ParseException e )");
        sc.add("{");
        sc.addIndented("throw " + exception + ";");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return null;");
    }
}

