/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jpox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.jpox.metadata.JPoxAssociationMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxClassMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxFieldMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreAssociationMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreFieldMetadata;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JPoxJdoMappingModelloGenerator
extends AbstractModelloGenerator {
    private static final Map PRIMITIVE_IDENTITY_MAP = new HashMap();

    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        try {
            File packageJdo = this.isPackageWithVersion() ? new File(this.getOutputDirectory(), "META-INF/package-" + this.getGeneratedVersion() + ".jdo") : new File(this.getOutputDirectory(), "META-INF/package.jdo");
            File parent = packageJdo.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new ModelloException("Error while creating parent directories for the file '" + packageJdo.getAbsolutePath() + "'.");
            }
            this.generatePackageJdo(packageJdo, model);
        }
        catch (IOException e) {
            throw new ModelloException("Error while writing package.jdo.", (Throwable)e);
        }
    }

    private void generatePackageJdo(File file, Model model) throws IOException, ModelloException {
        String packageName;
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(printWriter);
        HashMap<String, ArrayList<ModelClass>> classes = new HashMap<String, ArrayList<ModelClass>>();
        Iterator<Object> it = model.getClasses(this.getGeneratedVersion()).iterator();
        while (it.hasNext()) {
            ModelClass modelClass = (ModelClass)it.next();
            packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            ArrayList<ModelClass> list = (ArrayList<ModelClass>)classes.get(packageName);
            if (list == null) {
                list = new ArrayList<ModelClass>();
                classes.put(packageName, list);
            }
            list.add(modelClass);
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<!DOCTYPE jdo PUBLIC");
        printWriter.println("  \"-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.0//EN\"");
        printWriter.println("  \"http://java.sun.com/dtd/jdo_2_0.dtd\">");
        printWriter.println();
        writer.startElement("jdo");
        it = classes.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list.size() == 0) continue;
            packageName = ((ModelClass)list.get(0)).getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            writer.startElement("package");
            writer.addAttribute("name", packageName);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                ModelClass modelClass = (ModelClass)it2.next();
                this.writeClass((XMLWriter)writer, modelClass);
            }
            writer.endElement();
        }
        writer.endElement();
        printWriter.println();
        printWriter.close();
    }

    private void writeClass(XMLWriter writer, ModelClass modelClass) throws ModelloException {
        ModelField modelField;
        JPoxClassMetadata jpoxMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        writer.startElement("class");
        writer.addAttribute("name", modelClass.getName());
        ModelClass persistenceCapableSuperclass = null;
        if (modelClass.getSuperClass() != null) {
            persistenceCapableSuperclass = this.getModel().getClass(modelClass.getSuperClass(), this.getGeneratedVersion());
        }
        if (persistenceCapableSuperclass != null) {
            String superPackageName = persistenceCapableSuperclass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            writer.addAttribute("persistence-capable-superclass", superPackageName + "." + persistenceCapableSuperclass.getName());
        }
        writer.addAttribute("detachable", String.valueOf(jpoxMetadata.isDetachable()));
        List fields = Collections.unmodifiableList(modelClass.getFields(this.getGeneratedVersion()));
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        boolean applicationIdentityType = identifierFields.size() > 0;
        Iterator<Object> it = identifierFields.iterator();
        while (it.hasNext()) {
            modelField = (ModelField)it.next();
            if (PRIMITIVE_IDENTITY_MAP.containsKey(modelField.getType())) continue;
            throw new ModelloException("The JDO mapping generator does not support the specified field type '" + modelField.getType() + "'. " + "Supported types: " + PRIMITIVE_IDENTITY_MAP.keySet());
        }
        if (persistenceCapableSuperclass == null) {
            if (applicationIdentityType) {
                writer.addAttribute("identity-type", "application");
            }
        } else {
            writer.startElement("inheritance");
            writer.addAttribute("strategy", "new-table");
            writer.endElement();
        }
        it = fields.iterator();
        while (it.hasNext()) {
            modelField = (ModelField)it.next();
            if (!modelField.isIdentifier()) continue;
            writer.addAttribute("objectid-class", (String)PRIMITIVE_IDENTITY_MAP.get(modelField.getType()));
        }
        it = fields.iterator();
        while (it.hasNext()) {
            modelField = (ModelField)it.next();
            this.writeModelField(writer, modelField);
        }
        ArrayList<ModelField> detailedFields = new ArrayList<ModelField>();
        Iterator it2 = fields.iterator();
        while (it2.hasNext()) {
            StoreAssociationMetadata storeMetadata;
            ModelField field = (ModelField)it2.next();
            if (field.isPrimitive() || field instanceof ModelAssociation && (storeMetadata = this.getAssociationMetadata((ModelAssociation)field)).isPart() != null && storeMetadata.isPart().booleanValue()) continue;
            detailedFields.add(field);
        }
        this.writeFetchGroup(writer, modelClass.getName() + "_detail", detailedFields);
        HashMap fetchsMap = new HashMap();
        Iterator<Object> it3 = fields.iterator();
        while (it3.hasNext()) {
            ModelField field = (ModelField)it3.next();
            JPoxFieldMetadata jpoxFieldMetadata = (JPoxFieldMetadata)field.getMetadata(JPoxFieldMetadata.ID);
            List names = jpoxFieldMetadata.getFetchGroupNames();
            if (names == null) continue;
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String fetchGroupName = (String)i.next();
                List fetchList = null;
                fetchList = fetchsMap.get(fetchGroupName) == null ? new ArrayList() : (List)fetchsMap.get(fetchGroupName);
                fetchList.add(field);
                fetchsMap.put(fetchGroupName, fetchList);
            }
        }
        it3 = fetchsMap.keySet().iterator();
        while (it3.hasNext()) {
            String fetchName = (String)it3.next();
            this.writeFetchGroup(writer, fetchName, (List)fetchsMap.get(fetchName));
        }
        writer.endElement();
    }

    private void writeFetchGroup(XMLWriter writer, String fetchGroupName, List fields) {
        if (!fields.isEmpty()) {
            writer.startElement("fetch-group");
            writer.addAttribute("name", fetchGroupName);
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                ModelField field = (ModelField)it.next();
                writer.startElement("field");
                writer.addAttribute("name", field.getName());
                writer.endElement();
            }
            writer.endElement();
        }
    }

    private void writeModelField(XMLWriter writer, ModelField modelField) {
        writer.startElement("field");
        StoreFieldMetadata storeMetadata = (StoreFieldMetadata)modelField.getMetadata(StoreFieldMetadata.ID);
        JPoxFieldMetadata jpoxMetadata = (JPoxFieldMetadata)modelField.getMetadata(JPoxFieldMetadata.ID);
        writer.addAttribute("name", modelField.getName());
        if (!storeMetadata.isStorable()) {
            writer.addAttribute("persistence-modifier", "none");
        }
        if (modelField.isRequired()) {
            writer.addAttribute("null-value", "exception");
        }
        if (modelField.isIdentifier()) {
            writer.addAttribute("primary-key", "true");
            writer.addAttribute("value-strategy", "native");
        }
        if (jpoxMetadata.getMappedBy() != null) {
            writer.addAttribute("mapped-by", jpoxMetadata.getMappedBy());
        }
        if (modelField instanceof ModelAssociation) {
            this.writeAssociation(writer, (ModelAssociation)modelField);
        } else if (storeMetadata.getMaxSize() > 0) {
            writer.startElement("column");
            writer.addAttribute("length", String.valueOf(storeMetadata.getMaxSize()));
            writer.endElement();
        }
        writer.endElement();
    }

    private void writeAssociation(XMLWriter writer, ModelAssociation association) {
        StoreAssociationMetadata am = (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
        JPoxAssociationMetadata jpoxMetadata = (JPoxAssociationMetadata)association.getAssociationMetadata(JPoxAssociationMetadata.ID);
        if (am.isPart() != null) {
            writer.addAttribute("default-fetch-group", am.isPart().toString());
        }
        boolean dependent = true;
        if (am.isPart() != null) {
            dependent = am.isPart();
        }
        if (association.getType().equals("java.util.List") || association.getType().equals("java.util.Set")) {
            writer.startElement("collection");
            if (association.getTo().equals("String")) {
                writer.addAttribute("element-type", "java.lang.String");
            } else {
                writer.addAttribute("element-type", association.getTo());
            }
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-element", "true");
            } else {
                writer.addAttribute("dependent-element", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Map")) {
            writer.startElement("map");
            writer.addAttribute("key-type", am.getKeyType());
            if (association.getTo().equals("String")) {
                writer.addAttribute("value-type", "java.lang.String");
            } else {
                writer.addAttribute("value-type", association.getTo());
            }
            writer.addAttribute("dependent-key", "true");
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-value", "true");
            } else {
                writer.addAttribute("dependent-value", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Properties")) {
            writer.addAttribute("embedded", "false");
            writer.startElement("map");
            writer.addAttribute("key-type", "java.lang.String");
            writer.addAttribute("value-type", "java.lang.String");
            writer.addAttribute("embedded-key", "true");
            writer.addAttribute("embedded-value", "true");
            writer.addAttribute("dependent-key", "true");
            writer.addAttribute("dependent-value", "true");
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (jpoxMetadata.isDependent()) {
            writer.addAttribute("dependent", "true");
        }
    }

    private void writeExtension(XMLWriter writer, String vendorName, String key, String value) {
        writer.startElement("extension");
        writer.addAttribute("vendor-name", vendorName);
        writer.addAttribute("key", key);
        writer.addAttribute("value", value);
        writer.endElement();
    }

    private StoreAssociationMetadata getAssociationMetadata(ModelAssociation association) {
        return (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
    }

    static {
        PRIMITIVE_IDENTITY_MAP.put("short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("int", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Integer", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("String", "javax.jdo.identity.StringIdentity");
        PRIMITIVE_IDENTITY_MAP.put("char", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Character", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("byte", "javax.jdo.identity.ByteIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Byte", "javax.jdo.identity.ByteIdentity");
    }
}

