/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializable;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.ser.ArraySerializers;
import org.codehaus.jackson.map.ser.ContainerSerializers;
import org.codehaus.jackson.map.ser.EnumMapSerializer;
import org.codehaus.jackson.map.ser.EnumSerializer;
import org.codehaus.jackson.map.ser.JdkSerializers;
import org.codehaus.jackson.map.ser.MapSerializer;
import org.codehaus.jackson.map.ser.NullSerializer;
import org.codehaus.jackson.map.ser.StdSerializers;
import org.codehaus.jackson.map.ser.ToStringSerializer;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.map.util.EnumValues;
import org.codehaus.jackson.map.util.Provider;
import org.codehaus.jackson.map.util.SubTypeHelper;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.util.TokenBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSerializerFactory
extends SerializerFactory {
    static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    static final ArrayList<SerializerMapping> _abstractSerializers = new ArrayList();
    public static final BasicSerializerFactory instance;

    protected BasicSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type, SerializationConfig config) {
        return this.createSerializer(TypeFactory.type(type), config);
    }

    @Override
    public JsonSerializer<Object> createSerializer(JavaType type, SerializationConfig config) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type.getRawClass());
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo());
        if (ser == null && (ser = this.findSerializerByLookup(type, config, beanDesc)) == null && (ser = this.findSerializerByPrimaryType(type, config, beanDesc)) == null) {
            ser = this.findSerializerByAddonType(type, config, beanDesc);
        }
        return ser;
    }

    @Override
    public TypeSerializer createTypeSerializer(JavaType baseType, SerializationConfig config) {
        BasicBeanDescription bean = (BasicBeanDescription)config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(ac, baseType);
        List<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = SubTypeHelper.collectAndResolveSubtypes(ac, config, ai);
        }
        return b == null ? null : b.buildTypeSerializer(baseType, subtypes);
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    public final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JsonSerializer<?> ser = _concrete.get(type.getRawClass().getName());
        if (ser != null) {
            if (ser == MapSerializer.instance) {
                return this.buildMapSerializer(type, config, beanDesc);
            }
            if (ser == ArraySerializers.ObjectArraySerializer.instance) {
                return this.buildObjectArraySerializer(type, config, beanDesc);
            }
            if (ser == ContainerSerializers.IndexedListSerializer.instance) {
                return this.buildIndexedListSerializer(type, config, beanDesc);
            }
            if (ser == ContainerSerializers.CollectionSerializer.instance) {
                return this.buildCollectionSerializer(type, config, beanDesc);
            }
        }
        return ser;
    }

    public final JsonSerializer<?> findSerializerByPrimaryType(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        Class cls = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(cls)) {
            return StdSerializers.SerializableSerializer.instance;
        }
        if (Map.class.isAssignableFrom(cls)) {
            if (EnumMap.class.isAssignableFrom(cls)) {
                return this.buildEnumMapSerializer(type, config, beanDesc);
            }
            return this.buildMapSerializer(type, config, beanDesc);
        }
        if (Object[].class.isAssignableFrom(cls)) {
            return this.buildObjectArraySerializer(type, config, beanDesc);
        }
        if (List.class.isAssignableFrom(cls)) {
            if (cls == List.class || cls == AbstractList.class || RandomAccess.class.isAssignableFrom(cls)) {
                return this.buildIndexedListSerializer(type, config, beanDesc);
            }
            return this.buildCollectionSerializer(type, config, beanDesc);
        }
        if (Number.class.isAssignableFrom(cls)) {
            return StdSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            Class enumClass = cls;
            return EnumSerializer.construct(enumClass, config.getAnnotationIntrospector());
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return StdSerializers.CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return StdSerializers.UtilDateSerializer.instance;
        }
        int len = _abstractSerializers.size();
        for (int i = 0; i < len; ++i) {
            SerializerMapping map = _abstractSerializers.get(i);
            if (!map.matches(cls)) continue;
            return map.getSerializer();
        }
        if (Collection.class.isAssignableFrom(cls)) {
            if (EnumSet.class.isAssignableFrom(cls)) {
                return this.buildEnumSetSerializer(type, config, beanDesc);
            }
            return this.buildCollectionSerializer(type, config, beanDesc);
        }
        return null;
    }

    public final JsonSerializer<?> findSerializerByAddonType(JavaType javaType, SerializationConfig config, BasicBeanDescription beanDesc) {
        Class type = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            return this.buildIteratorSerializer(javaType, config, beanDesc);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.buildIterableSerializer(javaType, config, beanDesc);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializationConfig config, Annotated a) {
        Object serDef = config.getAnnotationIntrospector().findSerializer(a);
        if (serDef != null) {
            if (serDef instanceof JsonSerializer) {
                return (JsonSerializer)serDef;
            }
            if (!(serDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned value of type " + serDef.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class cls = (Class)serDef;
            if (!JsonSerializer.class.isAssignableFrom(cls)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + cls.getName() + "; expected Class<JsonSerializer>");
            }
            return (JsonSerializer)ClassUtil.createInstance(cls, config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
        }
        return null;
    }

    protected JsonSerializer<?> buildMapSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean staticTyping = this.usesStaticTyping(config, beanDesc);
        JavaType valueType = type.getContentType();
        TypeSerializer typeSer = this.createTypeSerializer(valueType, config);
        return MapSerializer.construct(intr.findPropertiesToIgnore(beanDesc.getClassInfo()), type, staticTyping, typeSer);
    }

    protected JsonSerializer<?> buildEnumMapSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType keyType = type.getKeyType();
        JavaType valueType = type.getContentType();
        EnumValues enums = null;
        if (keyType.isEnumType()) {
            Class enumClass = keyType.getRawClass();
            enums = EnumValues.construct(enumClass, config.getAnnotationIntrospector());
        }
        TypeSerializer typeSer = this.createTypeSerializer(valueType, config);
        return new EnumMapSerializer(valueType, this.usesStaticTyping(config, beanDesc), enums, typeSer);
    }

    protected JsonSerializer<?> buildObjectArraySerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(valueType, config);
        return ArraySerializers.objectArraySerializer(valueType, this.usesStaticTyping(config, beanDesc), vts);
    }

    protected JsonSerializer<?> buildIndexedListSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(valueType, config);
        return ContainerSerializers.indexedListSerializer(valueType, this.usesStaticTyping(config, beanDesc), vts);
    }

    protected JsonSerializer<?> buildCollectionSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(valueType, config);
        return ContainerSerializers.collectionSerializer(valueType, this.usesStaticTyping(config, beanDesc), vts);
    }

    protected JsonSerializer<?> buildIteratorSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.type(Object.class);
        }
        TypeSerializer vts = this.createTypeSerializer(valueType, config);
        return ContainerSerializers.iteratorSerializer(valueType, this.usesStaticTyping(config, beanDesc), vts);
    }

    protected JsonSerializer<?> buildIterableSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.type(Object.class);
        }
        TypeSerializer vts = this.createTypeSerializer(valueType, config);
        return ContainerSerializers.iterableSerializer(valueType, this.usesStaticTyping(config, beanDesc), vts);
    }

    protected JsonSerializer<?> buildEnumSetSerializer(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc) {
        JavaType enumType = type.getContentType();
        if (!enumType.isEnumType()) {
            enumType = null;
        }
        return ContainerSerializers.enumSetSerializer(enumType);
    }

    protected boolean usesStaticTyping(SerializationConfig config, BasicBeanDescription beanDesc) {
        JsonSerialize.Typing t = config.getAnnotationIntrospector().findSerializationTyping(beanDesc.getClassInfo());
        if (t != null) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING);
    }

    static {
        _concrete.put(String.class.getName(), new StdSerializers.StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        _concrete.put(Boolean.TYPE.getName(), new StdSerializers.BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new StdSerializers.BooleanSerializer(false));
        StdSerializers.IntegerSerializer intS = new StdSerializers.IntegerSerializer();
        _concrete.put(Integer.class.getName(), intS);
        _concrete.put(Integer.TYPE.getName(), intS);
        _concrete.put(Long.class.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Long.TYPE.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Byte.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Byte.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Float.class.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Float.TYPE.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Double.class.getName(), StdSerializers.DoubleSerializer.instance);
        _concrete.put(Double.TYPE.getName(), StdSerializers.DoubleSerializer.instance);
        StdSerializers.NumberSerializer ns = new StdSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(Calendar.class.getName(), StdSerializers.CalendarSerializer.instance);
        _concrete.put(Date.class.getName(), StdSerializers.UtilDateSerializer.instance);
        _concrete.put(java.sql.Date.class.getName(), new StdSerializers.SqlDateSerializer());
        _concrete.put(Time.class.getName(), new StdSerializers.SqlTimeSerializer());
        _concrete.put(Timestamp.class.getName(), StdSerializers.UtilDateSerializer.instance);
        _concrete.put(boolean[].class.getName(), new ArraySerializers.BooleanArraySerializer());
        _concrete.put(byte[].class.getName(), new ArraySerializers.ByteArraySerializer());
        _concrete.put(char[].class.getName(), new ArraySerializers.CharArraySerializer());
        _concrete.put(short[].class.getName(), new ArraySerializers.ShortArraySerializer());
        _concrete.put(int[].class.getName(), new ArraySerializers.IntArraySerializer());
        _concrete.put(long[].class.getName(), new ArraySerializers.LongArraySerializer());
        _concrete.put(float[].class.getName(), new ArraySerializers.FloatArraySerializer());
        _concrete.put(double[].class.getName(), new ArraySerializers.DoubleArraySerializer());
        _concrete.put(Object[].class.getName(), ArraySerializers.ObjectArraySerializer.instance);
        _concrete.put(String[].class.getName(), new ArraySerializers.StringArraySerializer());
        ContainerSerializers.IndexedListSerializer indListS = ContainerSerializers.IndexedListSerializer.instance;
        ContainerSerializers.CollectionSerializer collectionS = ContainerSerializers.CollectionSerializer.instance;
        _concrete.put(ArrayList.class.getName(), indListS);
        _concrete.put(Vector.class.getName(), indListS);
        _concrete.put(LinkedList.class.getName(), collectionS);
        MapSerializer mapS = MapSerializer.instance;
        _concrete.put(HashMap.class.getName(), mapS);
        _concrete.put(Hashtable.class.getName(), mapS);
        _concrete.put(LinkedHashMap.class.getName(), mapS);
        _concrete.put(TreeMap.class.getName(), mapS);
        _concrete.put(Properties.class.getName(), mapS);
        _concrete.put(HashSet.class.getName(), collectionS);
        _concrete.put(LinkedHashSet.class.getName(), collectionS);
        _concrete.put(TreeSet.class.getName(), collectionS);
        for (Map.Entry<Class<?>, JsonSerializer<?>> entry : new JdkSerializers().provide()) {
            _concrete.put(entry.getKey().getName(), entry.getValue());
        }
        _concrete.put(TokenBuffer.class.getName(), new StdSerializers.TokenBufferSerializer());
        for (String provStr : new String[]{"org.codehaus.jackson.map.ext.CoreXMLSerializers", "org.codehaus.jackson.map.ext.JodaSerializers"}) {
            Object ob = null;
            try {
                ob = Class.forName(provStr).newInstance();
            }
            catch (LinkageError e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ob == null) continue;
            Provider prov = ob;
            for (Map.Entry<Class<Object>, JsonSerializer<Object>> entry : prov.provide()) {
                Class<Object> cls = entry.getKey();
                if (ClassUtil.isConcrete(cls)) {
                    _concrete.put(entry.getKey().getName(), entry.getValue());
                    continue;
                }
                _abstractSerializers.add(new SerializerMapping(cls, entry.getValue()));
            }
        }
        instance = new BasicSerializerFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SerializerMapping {
        final Class<?> _class;
        final JsonSerializer<?> _serializer;

        public SerializerMapping(Class<?> c, JsonSerializer<?> ser) {
            this._class = c;
            this._serializer = ser;
        }

        public boolean matches(Class<?> c) {
            return this._class.isAssignableFrom(c);
        }

        public JsonSerializer<?> getSerializer() {
            return this._serializer;
        }
    }
}

