/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.loader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.maven.feature.Provider;
import org.codehaus.groovy.maven.feature.ProviderLoader;
import org.codehaus.groovy.maven.feature.ProviderRegistry;
import org.codehaus.groovy.maven.feature.ProviderSelector;
import org.codehaus.groovy.maven.runtime.loader.LoaderSupport;

public class DefaultProviderSelector
extends LoaderSupport
implements ProviderSelector {
    static final /* synthetic */ boolean $assertionsDisabled;

    public Provider select(ProviderRegistry registry, String selection) throws Exception {
        if (!$assertionsDisabled && registry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && selection == null) {
            throw new AssertionError();
        }
        this.log.trace("Select: {}", (Object)selection);
        this.register(registry, selection);
        Provider provider = null;
        if ("any".equals(selection)) {
            provider = this.selectAny(registry);
        } else {
            String[] keys = selection.split(",");
            for (int i = 0; i < keys.length; ++i) {
                Provider tmp = registry.lookup(keys[i]);
                if (tmp == null) continue;
                provider = tmp;
                break;
            }
        }
        if (this.log.isTraceEnabled()) {
            if (provider == null) {
                this.log.trace("No matching providers found for selection: {}", (Object)selection);
            } else if (!provider.supported()) {
                this.log.trace("Found unsupported provider matching selection: {}, found: {}", (Object)selection, (Object)provider);
            }
        }
        return provider;
    }

    private Provider selectAny(ProviderRegistry registry) {
        if (!$assertionsDisabled && registry == null) {
            throw new AssertionError();
        }
        Map supported = registry.providers(true);
        Provider provider = null;
        if (supported != null && !supported.isEmpty()) {
            provider = (Provider)supported.values().iterator().next();
        }
        return provider;
    }

    private void register(ProviderRegistry registry, String selection) throws Exception {
        if (!$assertionsDisabled && registry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && selection == null) {
            throw new AssertionError();
        }
        Map discovered = this.discover(registry, selection);
        if (discovered == null || discovered.isEmpty()) {
            this.log.debug("No providers discovered for selection: {}", (Object)selection);
        } else {
            this.log.debug("Registering {} providers:", (Object)String.valueOf(discovered.size()));
            Iterator iter = discovered.keySet().iterator();
            while (iter.hasNext()) {
                Provider replaced;
                String key = (String)iter.next();
                Provider provider = (Provider)discovered.get(key);
                this.log.debug("    {} -> {}", (Object)key, (Object)provider);
                if (!key.equals(provider.key())) {
                    this.log.warn("Found mismatch of provider key; discovered key: {}, provider's key: {}", (Object)key, (Object)provider.key());
                }
                if ((replaced = registry.register(provider)) == null) continue;
                this.log.warn("Replaced provider; key: {}, current: {}, replaced: {}", new Object[]{key, provider, replaced});
            }
        }
    }

    private Map discover(ProviderRegistry registry, String selection) throws Exception {
        if (!$assertionsDisabled && registry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && selection == null) {
            throw new AssertionError();
        }
        this.log.debug("Discovering providers for selection: {}", (Object)selection);
        HashMap discovered = null;
        String[] keys = selection.split(",");
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals("any")) continue;
            try {
                if (registry.lookup(keys[i]) != null) {
                    this.log.debug("Provider already registered for: {}", (Object)keys[i]);
                    continue;
                }
                Map found = this.load(keys[i]);
                if (found == null || found.isEmpty()) continue;
                if (discovered == null) {
                    discovered = new HashMap();
                }
                discovered.putAll(found);
                continue;
            }
            catch (Exception e) {
                this.log.debug("Failed to load providers for key: {}", (Object)keys[i], (Object)e);
            }
        }
        return discovered;
    }

    protected Map load(String key) throws Exception {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        Map found = null;
        Map loaders = this.findLoaders();
        if (loaders == null || loaders.isEmpty()) {
            this.log.debug("No provider loaders were found");
        } else {
            this.log.debug("Looking for provider {} in {}", (Object)key, (Object)loaders);
            Iterator iter = loaders.values().iterator();
            while (iter.hasNext()) {
                ProviderLoader loader = (ProviderLoader)iter.next();
                this.log.debug("Trying to load {} from {}", (Object)key, (Object)loader);
                try {
                    Map loaded = loader.load(key);
                    if (loaded == null || loaded.isEmpty()) continue;
                    found = loaded;
                    break;
                }
                catch (Exception e) {
                    this.log.warn("Failed to load provider from: {}", (Object)loader, (Object)e);
                }
            }
        }
        return found;
    }

    private Map findLoaders() {
        Set keys = this.getContainer().getComponentDescriptorMap(ProviderLoader.class.getName()).keySet();
        HashMap<String, ProviderLoader> found = null;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ProviderLoader loader;
            String key = (String)iter.next();
            try {
                loader = (ProviderLoader)this.getContainer().lookup((class$org$codehaus$groovy$maven$feature$ProviderLoader == null ? DefaultProviderSelector.class$("org.codehaus.groovy.maven.feature.ProviderLoader") : class$org$codehaus$groovy$maven$feature$ProviderLoader).getName(), key);
            }
            catch (Exception e) {
                this.log.warn("Failed to lookup provider loader for key: {}", (Object)key, (Object)e);
                continue;
            }
            if (loader == null) continue;
            if (found == null) {
                found = new HashMap<String, ProviderLoader>();
            }
            found.put(key, loader);
        }
        return found;
    }

    static {
        $assertionsDisabled = !DefaultProviderSelector.class.desiredAssertionStatus();
    }
}

