/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.v1_6;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.groovy.maven.feature.Component;
import org.codehaus.groovy.maven.feature.Feature;
import org.codehaus.groovy.maven.feature.support.FeatureSupport;
import org.codehaus.groovy.maven.runtime.StubCompiler;
import org.codehaus.groovy.maven.runtime.support.CompilerSupport;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ModelFactory;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.SourceDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.render.Renderer;
import org.codehaus.groovy.maven.runtime.support.stubgen.render.RendererFactory;
import org.codehaus.groovy.maven.runtime.v1_6.stubgen.ModelFactoryImpl;
import org.codehaus.groovy.maven.runtime.v1_6.stubgen.RendererFactoryImpl;

public class StubCompilerFeature
extends FeatureSupport {
    public StubCompilerFeature() {
        super(StubCompiler.KEY);
    }

    protected Component doCreate() throws Exception {
        return new StubCompilerImpl();
    }

    private class StubCompilerImpl
    extends CompilerSupport
    implements StubCompiler {
        private ModelFactory modelFactory;
        private RendererFactory rendererFactory;

        private StubCompilerImpl() throws Exception {
            super((Feature)StubCompilerFeature.this);
            this.modelFactory = new ModelFactoryImpl();
            this.rendererFactory = new RendererFactoryImpl();
        }

        public int compile() throws Exception {
            if (this.sources.isEmpty()) {
                this.log.debug("No sources added to compile; skipping");
                return 0;
            }
            this.log.debug("Compiling {} stubs for source(s)", (Object)String.valueOf(this.sources.size()));
            int count = 0;
            for (URL url : this.sources) {
                this.log.debug("    {}", (Object)url);
                count += this.render(url);
            }
            this.log.debug("Compiled {} stubs", (Object)String.valueOf(count));
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int render(URL url) throws Exception {
            assert (url != null);
            SourceDef model = this.modelFactory.create(url);
            Set renderers = this.rendererFactory.create(model);
            Iterator iter = renderers.iterator();
            int count = 0;
            while (iter.hasNext()) {
                Renderer renderer = (Renderer)iter.next();
                PrintWriter writer = this.createWriter(renderer, this.getTargetDirectory());
                try {
                    renderer.render((Writer)writer);
                    ++count;
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            return count;
        }

        private PrintWriter createWriter(Renderer renderer, File outputDir) throws IOException {
            assert (renderer != null);
            assert (outputDir != null);
            StringBuffer buff = new StringBuffer();
            String pkg = renderer.getPackage();
            if (pkg != null) {
                buff.append(pkg.replace('.', '/'));
                buff.append("/");
            }
            buff.append(renderer.getName());
            buff.append(".java");
            File outputFile = new File(outputDir, buff.toString());
            outputFile.getParentFile().mkdirs();
            return new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        }
    }
}

