/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.search;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.beans.FormPagedResult;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.beans.QueryParameters;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.models.EntityModel;
import org.chorem.vradi.ui.offer.OfferListUI;
import org.chorem.vradi.ui.offer.ThesaurusCartographyUI;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.search.CriteriaField;
import org.chorem.vradi.ui.search.CriteriaUI;
import org.chorem.vradi.ui.search.SearchUI;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class SearchHandler {
    private static final Log log = LogFactory.getLog(SearchHandler.class);
    public static final String CSV_FILE_EXTENSION = ".csv";
    public static final String DATE_CRITERIA_I18N_PREFIX = "vradi.criteria.typeDate.";

    public SearchUI initUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        this.initCriteria(ui);
        return ui;
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        return this.initCloneUI(rootContext, resultTableModel, null);
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel, Thesaurus thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        if (thesaurus != null) {
            ArrayList<Thesaurus> criteriaList = new ArrayList<Thesaurus>();
            criteriaList.add(thesaurus);
            this.initCriteria(ui, criteriaList);
        }
        return ui;
    }

    SearchUI getUI(JAXXContext context) {
        if (context instanceof SearchUI) {
            return (SearchUI)context;
        }
        SearchUI ui = null;
        if (context instanceof JAXXObject) {
            JAXXObject o = (JAXXObject)context;
            ui = (SearchUI)((Object)o.getParentContainer(SearchUI.class));
        }
        if (ui != null) {
            ui = (SearchUI)((Object)context.getContextValue(SearchUI.class));
        }
        return ui;
    }

    public List<Status> getAllStatuses() {
        return AdminHandler.getAllStatuses();
    }

    public List<XmlStream> getAllStreams() {
        return VradiService.getVradiDataService().findAllXmlStreams();
    }

    public void executeQuery(SearchUI searchUI) {
        String query = searchUI.getRequest();
        JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
        CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
        OfferListTableModel listTableModel = searchUI.getResultTableModel();
        FormPagedResult formPageDTO = listTableModel.getFormPagedResult();
        FormPagedResult result = this.executeQuery(searchUI, criterias, formPageDTO, combo, query);
        listTableModel.setFormPagedResult(result);
    }

    public void executeQuery(SearchUI searchUI, int pageToShow) {
        OfferListTableModel listTableModel = searchUI.getResultTableModel();
        listTableModel.setPageToShow(pageToShow);
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public JPanel getCriteriaPanel(SearchUI searchUI) {
        CriteriaUI criterias = searchUI.getCriterias();
        return criterias.getCriteriaPanel();
    }

    public CriteriaUI getCriterias(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(SearchUI searchUI) {
        this.initCriteria(searchUI, null);
    }

    public void initCriteria(SearchUI searchUI, List<Thesaurus> thesaurus) {
        this.getCriteriaPanel(searchUI).removeAll();
        List<String> rootThesaurusListCriteria = VradiHelper.getVradiListRootCriteria();
        for (String value : rootThesaurusListCriteria) {
            this.addCriteria(searchUI, value, true);
        }
        List<String> thesaurusListCriteria = VradiHelper.getVradiListCriteria();
        for (String value : thesaurusListCriteria) {
            this.addCriteria(searchUI, value, true);
        }
        if (thesaurus != null) {
            for (Thesaurus t : thesaurus) {
                this.addUnmodifiableCriteria(searchUI, t);
            }
        }
    }

    public void removeCriteria(SearchUI searchUI, CriteriaField criteriaField) {
        this.getCriteriaPanel(searchUI).remove((Component)((Object)criteriaField));
        searchUI.validate();
    }

    public void removeCriteriaAndPersist(CriteriaField criteriaField, Thesaurus bean) {
        this.removeCriteriaAndPersist(this.getUI((JAXXContext)criteriaField), criteriaField, bean);
    }

    public void removeCriteriaAndPersist(SearchUI searchUI, CriteriaField criteriaField, Thesaurus bean) {
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(searchUI, criteriaField);
        searchUI.validate();
    }

    public void removeRootCriteriaAndPersist(CriteriaField criteriaField, RootThesaurus bean) {
        this.removeRootCriteriaAndPersist(this.getUI((JAXXContext)criteriaField), criteriaField, bean);
    }

    public void removeRootCriteriaAndPersist(SearchUI searchUI, CriteriaField criteriaField, RootThesaurus bean) {
        VradiHelper.removeVradiListRootCriteria(bean);
        this.removeCriteria(searchUI, criteriaField);
        searchUI.validate();
    }

    public void addUnmodifiableCriteria(SearchUI searchUI, Thesaurus thesaurus) {
        CriteriaField criteriaField;
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
            criteriaField = this.addCriteria(searchUI, root, false, false);
        } else {
            Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(thesaurus.getParent());
            criteriaField = this.addCriteria(searchUI, parent, false, false);
        }
        JComboBox combo = criteriaField.getCombo();
        combo.getModel().setSelectedItem(thesaurus);
        combo.setSelectedItem(thesaurus);
    }

    public void addAndPersistCriteria(JAXXContext context, Thesaurus thesaurus) {
        this.addAndPersistCriteria(this.getUI(context), thesaurus);
    }

    public void addAndPersistCriteria(SearchUI searchUI, Thesaurus thesaurus) {
        VradiHelper.addVradiListCriteria(thesaurus);
        this.addCriteria(searchUI, thesaurus, true, true);
    }

    protected void addRootCriteria(SearchUI searchUI, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        RootThesaurus criteriaThe = ThesaurusDataHelper.restoreRootThesaurus(wikittyId);
        if (criteriaThe != null) {
            this.addCriteria(searchUI, criteriaThe, deletable, true);
        }
    }

    protected void addCriteria(SearchUI searchUI, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        Thesaurus criteriaThe = ThesaurusDataHelper.restoreThesaurus(wikittyId);
        if (criteriaThe != null) {
            this.addCriteria(searchUI, criteriaThe, deletable, true);
        }
    }

    protected CriteriaField addCriteria(SearchUI searchUI, RootThesaurus thesCriteria, boolean deletable, boolean enabled) {
        CriteriaField criteriaField = new CriteriaField((JAXXContext)searchUI);
        criteriaField.setLabelName(thesCriteria.getName());
        criteriaField.setRootThesaurus(thesCriteria);
        try {
            List children = VradiService.getVradiDataService().getChildrenThesaurus(thesCriteria.getWikittyId());
            this.initCriteriaField(searchUI, criteriaField, children, deletable, enabled);
        }
        catch (VradiException ex) {
            throw new RuntimeException("Can't get children thesaurus", ex);
        }
        return criteriaField;
    }

    protected CriteriaField addCriteria(SearchUI searchUI, Thesaurus thesCriteria, boolean deletable, boolean enabled) {
        CriteriaField criteriaField = new CriteriaField((JAXXContext)searchUI);
        criteriaField.setLabelName(thesCriteria.getName());
        criteriaField.setThesaurus(thesCriteria);
        List children = null;
        String thesaurusId = thesCriteria.getWikittyId();
        try {
            children = VradiService.getVradiDataService().getChildrenThesaurus(thesaurusId);
        }
        catch (VradiException eee) {
            log.error((Object)("Can't restore children of thesaurus '" + thesaurusId + "' : "), (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        this.initCriteriaField(searchUI, criteriaField, children, deletable, enabled);
        return criteriaField;
    }

    protected void initCriteriaField(SearchUI searchUI, CriteriaField criteriaField, List<Thesaurus> children, boolean deletable, boolean enabled) {
        criteriaField.setDeletable(deletable);
        criteriaField.setActif(enabled);
        JComboBox combo = criteriaField.getCombo();
        combo.setModel(new EntityModel<Thesaurus>(Thesaurus.class, children, true));
        combo.setMaximumRowCount(30);
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        JPanel criteriaPanel = this.getCriteriaPanel(searchUI);
        criteriaPanel.add((Component)((Object)criteriaField));
        searchUI.validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Infogene.creationDate");
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public DefaultComboBoxModel updateDateSelectionModel(WikittyExtension selected) {
        List<String> datas = this.getDateFormType(selected);
        return new DefaultComboBoxModel<String>(datas.toArray(new String[datas.size()]));
    }

    public FormPagedResult executeQuery(final SearchUI searchUI, CriteriaUI criterias, FormPagedResult formPagedResult, final JComboBox combo, final String request) {
        if (criterias == null) {
            QueryParameters queryParameters = new QueryParameters(request);
            formPagedResult = VradiHelper.executeQuery(queryParameters, formPagedResult);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel(searchUI).getComponents();
            ArrayList<Thesaurus> thesaurus = new ArrayList<Thesaurus>();
            for (Component aThesaurusCriteria : thesaurusCriteria) {
                Thesaurus tn = (Thesaurus)((CriteriaField)((Object)aThesaurusCriteria)).getCombo().getSelectedItem();
                if (tn == null || !StringUtils.isNotBlank((String)tn.getName())) continue;
                String wikittyId = tn.getWikittyId();
                Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                thesaurus.add(parent);
            }
            formPagedResult = this.executeQuery(request, criterias, thesaurus, formPagedResult);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Total forms found        : " + formPagedResult.getTotalFoundFormNb()));
            log.info((Object)("Number of forms per page : " + formPagedResult.getNbFormsToShow()));
            log.info((Object)("Actual page              : " + formPagedResult.getPageToShow()));
        }
        if (searchUI.getParentContainer(OfferListUI.class) != null) {
            VradiHelper.addRequestToProperties(request);
        }
        if (combo != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultComboBoxModel model = searchUI.getRequestModel();
                    model.removeElement(request);
                    model.insertElementAt(request, 0);
                    combo.setSelectedItem(request);
                }
            });
        }
        return formPagedResult;
    }

    public DefaultComboBoxModel getRequestModel() {
        List<String> queries = this.loadRequests();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(queries.toArray());
        return model;
    }

    public void updateRequests(SearchUI searchUI) {
        JComboBox groupsCombo = searchUI.getGroups();
        Group selected = (Group)groupsCombo.getSelectedItem();
        JComboBox requestCombo = searchUI.getRequests();
        if (selected == null) {
            requestCombo.setModel(searchUI.getRequestModel());
            return;
        }
        Set queries = selected.getQueries();
        ArrayList<QueryBean> queriesBean = new ArrayList<QueryBean>();
        if (queries != null) {
            for (String query : queries) {
                try {
                    QueryBean queryBean = new QueryBean(query);
                    queriesBean.add(queryBean);
                }
                catch (IOException eee) {
                    log.error((Object)("Cant parse query : " + query), (Throwable)eee);
                    ErrorDialogUI.showError((Exception)eee);
                }
            }
        }
        requestCombo.setModel(new DefaultComboBoxModel<Object>(queriesBean.toArray()));
        requestCombo.setSelectedItem(searchUI.getRequest());
    }

    public void executeCartography(SearchUI searchUI) {
        QueryParameters queryParameters = this.getQueryParameters(searchUI);
        ThesaurusTreeTableHelper thesaurusTreeTableHelper = new ThesaurusTreeTableHelper(queryParameters);
        ThesaurusCartographyUI cartographyUI = new ThesaurusCartographyUI((JAXXContext)searchUI, thesaurusTreeTableHelper);
        cartographyUI.setLocationRelativeTo((Component)((Object)searchUI));
        cartographyUI.setVisible(true);
    }

    protected QueryParameters getQueryParameters(SearchUI searchUI) {
        String request = searchUI.getRequest();
        JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
        CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
        QueryParameters queryParameters = new QueryParameters(request);
        if (criterias != null) {
            Component[] thesaurusCriteria = this.getCriteriaPanel(searchUI).getComponents();
            ArrayList<Thesaurus> thesaurus = new ArrayList<Thesaurus>();
            for (Component aThesaurusCriteria : thesaurusCriteria) {
                Thesaurus tn = (Thesaurus)((CriteriaField)((Object)aThesaurusCriteria)).getCombo().getSelectedItem();
                thesaurus.add(tn);
            }
            queryParameters.setThesaurus(thesaurus);
            Calendar beginDate = Calendar.getInstance();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            queryParameters.setBeginDate(beginDate.getTime());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            queryParameters.setEndDate(endDate.getTime());
            WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
            queryParameters.setExtension(extension);
            String dateFieldName = (String)criterias.getDateTypeSelection().getSelectedItem();
            queryParameters.setDateFieldName(dateFieldName);
            List<Status> statuses = criterias.getStatusSelection().getSelectedValues();
            List statusIds = VradiHelper.extractIds(statuses);
            queryParameters.setStatusIds(statusIds);
            List<XmlStream> xmlStreams = criterias.getXmlStreamSelection().getSelectedValues();
            List streamIds = VradiHelper.extractIds(xmlStreams);
            queryParameters.setStreamIds(streamIds);
        }
        return queryParameters;
    }

    public FormPagedResult executeQuery(String request, CriteriaUI criterias, List<Thesaurus> thesauruses, FormPagedResult formPagedResult) {
        QueryParameters queryParameters = new QueryParameters(request);
        if (criterias != null) {
            Calendar beginDate = Calendar.getInstance();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            queryParameters.setBeginDate(beginDate.getTime());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            queryParameters.setEndDate(endDate.getTime());
            WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
            queryParameters.setExtension(extension);
            String dateFieldName = (String)criterias.getDateTypeSelection().getSelectedItem();
            queryParameters.setDateFieldName(dateFieldName);
            List<Status> statuses = criterias.getStatusSelection().getSelectedValues();
            List statusIds = VradiHelper.extractIds(statuses);
            queryParameters.setStatusIds(statusIds);
            List<XmlStream> xmlStreams = criterias.getXmlStreamSelection().getSelectedValues();
            List streamIds = VradiHelper.extractIds(xmlStreams);
            queryParameters.setStreamIds(streamIds);
        }
        queryParameters.setThesaurus(thesauruses);
        FormPagedResult result = VradiHelper.executeQuery(queryParameters, formPagedResult);
        return result;
    }

    public ListCellRenderer getDateTypeComboBoxRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = -1967943679031854092L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    int dot;
                    stringValue = value.toString();
                    String extName = stringValue.substring(0, dot = stringValue.lastIndexOf("."));
                    stringValue = "Infogene".equals(extName) || "Form".equals(extName) ? I18n._((String)(SearchHandler.DATE_CRITERIA_I18N_PREFIX + stringValue), (Object[])new Object[0]) : stringValue.substring(dot + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public void exportToCSV(OfferListTableModel offerListTableModel) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        File file = UIHelper.openFileChooser(CSV_FILE_EXTENSION, I18n._((String)"vradi.export.filter.csv", (Object[])new Object[0]), ui, I18n._((String)"vradi.export.validate.label", (Object[])new Object[0]));
        if (file != null) {
            UIHelper.exportToCSV(file, offerListTableModel);
        }
    }
}

