/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.email;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.ui.email.EmailContentUI;
import org.chorem.vradi.ui.email.QueryMakerViewUI;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.email.models.GroupEmailEntityModel;
import org.chorem.vradi.ui.email.models.UserEmailEntityModel;
import org.chorem.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.i18n.I18n;

public class FormViewUI
extends EmailContentUI {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";
    public static final String BINDING_GROUPS_FORM_FORM = "groupsForm.form";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_FORM = "usersForm.form";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdmziOHT6CI0ICIUrABQrozEeDlACBgEUiJwhMUIQb9nyLveF8t+zuJZcUiJ/AT4CeBomOClFQU9Ag/gJCFLSI2buzHZMzsbCLsz0z782b8Ru/+Q4pKWBmg/i+ITxHsQY1lm+sr981N2hV3aKyKhhXroDwlUhCsgLDVisuFZyplDS8EMELi26Duw51dqHnSpCVatumsk6pUnCqE1GVslBuped87okma0tUHOurnz+SL60Xr5MAPkd1QzjK9H6o9iQDJUgyS0EOO22Sgk2cGsoQzKmh3kM6tmgTKVdJgz6D55AuwSAnAskUnO595IAjwPtcwUj+doMwe9F1FJavLV1QkHdFzajWXUEbxqYgFjM8ZlBdZRRd0XjI6NbaEucBx6CCtKRSMsTDzB4gUjLFqDTKYU0bNWBSgpCp7hDda1eX/ANi2hTljXcsVG7heowgpyszLcBQfrlETGojIqdX50elYVQX5Vq12ZpwPS51RwWz3ce/51GxvUKeUhEuoZOl2fGi/n68M5fxJBVBAx04ESUFnOwYBn1ntH3XNkaiAinhYRinr+y16n1MhSYd/8ukmjDI/h4b/fL+27ti05lZ7H0stnTXYaFjuHA5Ffr3UHAktKWnmF1YIXyuAhlJbbzK4OomY4SVozSKw35HNdzQcOMOkXWkSKW/fvg49vjzAUgWIWu7xCoSXb8EGVUXuAXXtnx+fSFQdHBrCJ8jWhvaR1EfbZ+bZ47NHDpNFN6J6Sl6zcc1TMasoaXFzHz6NVp+u9BcRQKlTXQtb68j9QgGw27BmUYXGHuWw1xSz3LblxZ3ewn9PsYji+eD59m4WVNVm+zsKDg8bxFFpk3mWGhkHFQjzgcT6E9GQDjRA2GaOvpeghEu/z/NwJPIzn1wNP88+qLR4Vn9OBfPMNkTw6V/aJjqieFK3wxX+2a4uQ/DH6tT2BphBwAA";
    private static final Log log = LogFactory.getLog(FormViewUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    protected Form bean;
    protected QueryMakerViewUI<Group> groupsForm;
    protected Session session;
    protected QueryMakerViewUI<User> usersForm;
    private FormViewUI $EmailContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    @Override
    public void openUI(VradiTreeNode node) {
        this.getHandler().displayForm((JAXXContext)this, node);
        Form formSelected = this.getContextValue(Form.class);
        this.setBean(formSelected);
        this.session = this.getHelper().getSessionToDisplay(node);
        this.updateSession(this.session);
    }

    public void updateSession(Session currentSession) {
        this.setSession(currentSession);
        this.groupsForm.setSession(currentSession);
        this.usersForm.setSession(currentSession);
        List<User> userSending = EmailDataHelper.getUsersSendingConcernedBy(this.session, this.bean.getWikittyId());
        List<User> allUsers = this.getAdminHandler().getAllUsers();
        allUsers.removeAll(userSending);
        EmailFormsListCellRenderer emailFormsCellRenderer = new EmailFormsListCellRenderer();
        emailFormsCellRenderer.updateDatas(this.getSession(), this.getBean().getWikittyId());
        this.usersForm.init(true, this.getBean(), emailFormsCellRenderer, allUsers, userSending);
        this.usersForm.getQueryMakerForm().getList().setModel(new UserEmailEntityModel(emailFormsCellRenderer, this.session, this.getBean()));
        List<Group> groupSending = EmailDataHelper.getGroupsSendingConcernedBy(this.session, this.bean.getWikittyId());
        List<Group> allGroups = this.getAdminHandler().getAllGroups();
        allGroups.removeAll(groupSending);
        this.groupsForm.init(true, this.getBean(), emailFormsCellRenderer, allGroups, groupSending);
        this.groupsForm.getQueryMakerForm().getList().setModel(new GroupEmailEntityModel(emailFormsCellRenderer, this.session, this.getBean()));
        this.usersForm.setEnabled(this.sessionCanBeSent());
        this.groupsForm.setEnabled(this.sessionCanBeSent());
    }

    protected boolean sessionCanBeSent() {
        if (this.session == null) {
            return false;
        }
        return VradiConstants.SessionStatus.isActive((Session)this.session);
    }

    public FormViewUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public FormViewUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public FormViewUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public FormViewUI(JAXXContext param0, LayoutManager param1) {
        super(param0, param1);
        this.$initialize();
    }

    public FormViewUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public FormViewUI(JAXXContext param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public FormViewUI() {
        this.$initialize();
    }

    public FormViewUI(JAXXContext param0) {
        super(param0);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public Form getBean() {
        return this.bean;
    }

    public QueryMakerViewUI<Group> getGroupsForm() {
        return this.groupsForm;
    }

    public Session getSession() {
        return this.session;
    }

    public QueryMakerViewUI<User> getUsersForm() {
        return this.usersForm;
    }

    public void setBean(Form bean) {
        Form oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setSession(Session session) {
        Session oldValue = this.session;
        this.session = session;
        this.firePropertyChange(PROPERTY_SESSION, oldValue, session);
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    protected void createGroupsForm() {
        this.groupsForm = new QueryMakerViewUI((JAXXContext)this);
        this.$objectMap.put("groupsForm", this.groupsForm);
        this.groupsForm.setName("groupsForm");
    }

    protected void createSession() {
        this.session = null;
        this.$objectMap.put(PROPERTY_SESSION, null);
    }

    protected void createUsersForm() {
        this.usersForm = new QueryMakerViewUI((JAXXContext)this);
        this.$objectMap.put("usersForm", this.usersForm);
        this.usersForm.setName("usersForm");
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.add((Component)this.$Table0, "Center");
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add(this.groupsForm, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add(this.usersForm, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.groupsForm.setClazz(Group.class);
        this.groupsForm.setEnabled(this.sessionCanBeSent());
        this.usersForm.setClazz(User.class);
        this.usersForm.setEnabled(this.sessionCanBeSent());
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$EmailContentUI0", this.$EmailContentUI0);
        this.createSession();
        this.createBean();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"vradi.email.formGroupTitle", (Object[])new Object[0]));
        this.createGroupsForm();
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"vradi.email.formUserTitle", (Object[])new Object[0]));
        this.createUsersForm();
        this.setName("$EmailContentUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_FORM, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                FormViewUI.this.groupsForm.setForm(FormViewUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true, new String[]{PROPERTY_SESSION}){

            public void processDataBinding() {
                FormViewUI.this.groupsForm.setSession(FormViewUI.this.getSession());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_FORM, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                FormViewUI.this.usersForm.setForm(FormViewUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true, new String[]{PROPERTY_SESSION}){

            public void processDataBinding() {
                FormViewUI.this.usersForm.setSession(FormViewUI.this.getSession());
            }
        });
    }
}

