/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.ui.admin.content.AdminThesaurusHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.ThesaurusHighlighter;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class ThesaurusCartographyUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_HIGHLIGHTERS = "thesaurus.highlighters";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVlps+SHSgKiogFzdcocgWkOgKWIoGmIvTrvT7uB0Z5x5C4sH45/gn6B3LybePBkPnj14Mf4Lxnjwanyz/QW6YCNN2m3mzfe97733vX39jaSMJrO7NAwdHfjAm8wp3trZ2azushrcYaamuQKpSeuTSJJkhQy53XMD5HqlZOH5NjxfkE0lfeYfQi+WSNbAgWDGYwyAXDmKqBmTL3fDi6EKdIe1KyqO9eWP78kX7vNXSUJCheoGsJSZf6F6lQyUSJK7QMYx0x7NC+o3UIbmfgP1jtizgqDG3KVN9oQ8I4MlklZUIxmQuf5LjjgifKiATILHDA10YApUg2xoqryD++tAFqRuODVPatZ09jR1uRNwR9brTDvbsRClItY0kJH5YrmmpRD3qM8WgFyw0kPH7GMlzqGQvZ7pojJdJUCu2eS7ONXHIFULGDrFnW3N2Datigg53EPOF28HANLHXLkjuVrH7TyaXD4yC5yy05tybwyJCknpAI+BTFX+NsYWhlqWmPrDEpYwiv6azH1+9/XtascHWcw9EXv1kI1xPkpLxTRwm/pcywQBcJHfoGqxQjKGCdyByOPTMcLK7TCKw3znLdyxcGeNGg8pUoNf3n+YfPTpDEmukqyQ1F2l9v66bb3GLkjhhurmSqRoeP8s/o5ZbUAmXFangYCCkIZtokQKXPpARpdcCnSmyn0X270cYk+mY3rSFVbNfPyZK79Z6fQlgTovHnu915vUQ5LmvuA+izakbf7YjRhShgWu7Jk8zvYJ+8yqtmMvRb9X4wpPC3ogA7Dx2TCwj7lItv033zdLCjgIdNj4UquIGQq41dUA2PL/k2bqOIEbhj+NKnfiicb6IBr2eMMT+AWmzQmV9sM1pKWEB9zw9o6eQtYY+nHfbCHfGvVd3MZT8o1C5+WxIV0mTlnoAK+13ivHcOT64QAWwglVWY7fznRt8xAHAAA=";
    private static final Log log = LogFactory.getLog(ThesaurusCartographyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTreeTable thesaurus;
    protected ThesaurusCartographyUI thesaurusCartographyUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    protected ThesaurusHighlighter highlighter;
    
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        // Register tree table
        helper.setUI(thesaurus, true, false, null);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(highlighter);
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusCartographyUI(JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        SwingUtil.initContext(this, parentContext);
            this.helper = helper;
            setContextValue(helper);
            highlighter = new ThesaurusHighlighter(helper.getDataProvider());
            $initialize();
    }

    public ThesaurusCartographyUI() {
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusCartographyUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusCartographyUI(String param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusCartographyUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doWindowClosing__on__thesaurusCartographyUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTreeTable getThesaurus() {
        return thesaurus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusCartographyUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusCartographyUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("close"));
        // late initializer
        thesaurusCartographyUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusCartographyUI", thesaurusCartographyUI);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of thesaurusCartographyUI
        setName("thesaurusCartographyUI");
        thesaurusCartographyUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.thesaurusCartographyUI.title"));
        thesaurusCartographyUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__thesaurusCartographyUI"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_HIGHLIGHTERS, true ,"highlighter") {
        
            @Override
            public void processDataBinding() {
                thesaurus.setHighlighters(highlighter);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}