/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import org.chorem.vradi.ui.email.renderers.EmailCellRenderer;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.jdesktop.swingx.JXDatePicker;
import static org.chorem.vradi.VradiConstants.SessionStatus;
import static org.nuiton.i18n.I18n._;

public class EmailPopupUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHFSJzENNnFbNSCHRoUDrNuAhFBKf7mJGsslUR3agC+Mdyf2pOOdZWY22fSAkPgH+BPgzgWpN06IA2cOXBD/AkIcuCLe7Nq73mS9XuEc1sm89775vveev833f6K8FGjtCHueIVxb0T4xGvcPDnY7R8RUD4k0BXUUFyj4mcmhXBstWuG5VOh6u6nLa4PyWp33HW4Te6R6s4kWpDplRPYIUQq9Hq8wpay1wvCm57hiiBqSSkL99u+/ct9YX32XQ8hzgF0FpFQnVUVKZpsoRy2FSnDTMa4xbHeBhqB2F/gW9VmdYSk/xn3yBfoSzTfRnIMFgCn0ZnbJPoZf7zkKLZE+pmyPO67zyY5CN7joGmaPC9I3jgW2qOFSw08xtkYSHcdHmFOoaHJbwUVNfMpdIPJGTK48AfJGHQsriG9EhUvrjZbDqNrDNrmpUEXL8wYFUUQnF8Kai+sNfcggvxTL90910qVzubf036/pRymMza/v4w7T115JoOvHdObKKFgTdxIu9k910uUw91VJpKTcfogV2aPmcyIUquq2HsGWPlfcCWo9o3EQpcQhhtf53FfjseIhZYqIeo9zqaFXYnxg8B3+gHvxmsJ64wEMh9vAvxzLD47jYoswGVNwxgajuRwfTRiK9/SCjY9BfCx3XxA/6+2o84N1CYdyfmAbYcwIY7M2D+7zm3Hz7CD9Pl2N70qo2Q++pR/vR8snCRZmL1J/Jr4oiW21gjkmhIsWYUSR8Qnh5RujQYGuxdYNbMaIbCbygZk2ygsXjmE/2+ed6QmEAk+6csaTNKAf/bdS/u3HP15uD41oDe5eSUwd8VEwCEdwB5aK6qsvBS7kKspqj7Gz2UYFCbLNwGRXE4i1BmEgB/f5q2DocuMRlj2AyM///tPPlc9/vYBy22iBcWxtY52/gwqqJ6ALnFmec/eez2jp5CI8lzU3WHKLHGKXqTqDpd8FilhB4xV65baFFa52qG3Bwt3xoCerCT0JiXUKv/xTbv1wb9iXGeB5dWx61Jv8Z2iO2ozaxLfogfsmWvKiI4lr8chlk3x3Rn8uOAM33PKfO0nC55jvmzre9Fz98dinrX/bzYySV1TBwqLS7UBEFSt4rXRcRe78f9CqC6Ow2elTKil8B6NXDrTRHn4vPk3GL2bALwHaPnfN3pbnYNsamvIYxOUMiEuwY/QFeUZot5fW0slY+riVglCeGqGSQc+sIp5K6cm1TCzcFIS1LMvV51bwDhwj5XoWKdQMFmYMxo0MGIVDsIR39YRTFL2TAWhRcK4Gaz0l1DKY2ol8AniPYIfB0qfCm7Q0takRbmXQVIZ/D+kL6DVm9xnt2v3B+3yMrPem3sJsCF+nyPpgag7ZENI4fJihtfPE1j5nTQUzSUo2hDQpm5kQXk6NkKYiG0Kaio+mVpENIU3FZARYiuOJVpSNSFoz7k4tRSP8ByEEaZO/DwAA";
    private static final Log log = LogFactory.getLog(EmailPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected JButton deleteSession;
    protected EmailPopupUI emailPopupUI = this;
    protected JComboBox filterChooser;
    protected JTree nav;
    protected JLabel none;
    protected JButton searchButton;
    protected JButton sendSession;
    protected JXDatePicker sessionDatePicker;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSplitPane $JSplitPane0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private JPanel $JPanel2;
    private Table $Table1;
    private JButton $JButton1;
    private JButton $JButton2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String NONE = "none";
    protected EmailNavigationTreeHelper helper;
    
    
    protected EmailNavigationTreeHelper getHelper() {
        return helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    
        final VradiDataProvider dataProvider = new VradiDataProvider();
    
        helper = new EmailNavigationTreeHelper(dataProvider);
        setContextValue(helper);
    
        // Creation of selection listener to open ui when tree selection change
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent event) {
    
                // If nothing is selected
                if (nav.getSelectionModel().isSelectionEmpty()) {
                    getContentLayout().show(getContent(), NONE);
                    return;
                }
    
                TreePath path = event.getPath();
                VradiTreeNode node = (VradiTreeNode) path.getLastPathComponent();
    
                if (log.isDebugEnabled()) {
                    log.debug("Select node " + node);
                }
    
                getHandler().openUI(EmailPopupUI.this, contentLayout, content, node);
                updateButtons();
            }
        };
                      
        // Register tree
        helper.setUI(nav, true, selectionListener);
    
        sessionDatePicker.setDate(new Date());
    
        updateTree();
        SwingUtil.addExpandOnClickListener(nav);
    
        // Attach renderer
        nav.setCellRenderer(new EmailCellRenderer(dataProvider));
    
        // Single selection mode
        nav.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    
        // Tooltip is not active without this code...
        javax.swing.ToolTipManager.sharedInstance().registerComponent(nav);
    
        this.pack();
    }
    
    public void updateTree() {
        if (log.isDebugEnabled()) {
            log.debug("updateTree");
        }
        Date searchDate = sessionDatePicker.getDate();
        java.util.List<Session> sessions = getHandler().getSessions(searchDate);
        helper.updateTree(sessions, (EmailNavigationTreeHelper.EmailFilterEnum)filterChooser.getSelectedItem(), searchDate);
        updateButtons();
    }
    
    protected void sendSession() {
        // disable buttons to avoid duplicate send
        boolean started = getHandler().send(this);
        updateButtons();
    }
    
    protected void updateButtons() {
        sendSession.setEnabled(canBeSend());
        deleteSession.setEnabled(isActiveSession());
        searchButton.setEnabled(isActiveSession());
    }
    
    protected boolean isActiveSession() {
        if (helper == null) {
            return false;
        }
        Session session = helper.getSelectedActiveSession();
    
        if (session == null) {
            return false;
        }
    
        return true;
    }
    
    protected boolean canBeSend() {
        if (helper == null) {
            return false;
        }
        Session session = helper.getSessionSelected();
    
        if (session == null) {
            return false;
        }
    
        if (SessionStatus.isToSend(session)) {
            return true;
        }
        return false;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailPopupUI() {
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EmailPopupUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EmailPopupUI(String param0) {
        super(param0);
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EmailPopupUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateTree();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createNewSession(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    public void doActionPerformed__on__deleteSession(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteSession(this);
    }

    public void doActionPerformed__on__searchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().bindEmailsWithForms(this);
    }

    public void doActionPerformed__on__sendSession(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sendSession();
    }

    public void doWindowClosing__on__emailPopupUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public JButton getDeleteSession() {
        return deleteSession;
    }

    public JComboBox getFilterChooser() {
        return filterChooser;
    }

    public JTree getNav() {
        return nav;
    }

    public JLabel getNone() {
        return none;
    }

    public JButton getSearchButton() {
        return searchButton;
    }

    public JButton getSendSession() {
        return sendSession;
    }

    public JXDatePicker getSessionDatePicker() {
        return sessionDatePicker;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JPanel2, NONE);
    }

    protected void addChildrenToEmailPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createDeleteSession() {
        $objectMap.put("deleteSession", deleteSession = new JButton());
        
        deleteSession.setName("deleteSession");
        deleteSession.setText(_("vradi.email.deleteSession"));
        deleteSession.setVisible(true);
        deleteSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteSession"));
    }

    protected void createFilterChooser() {
        $objectMap.put("filterChooser", filterChooser = new JComboBox());
        
        filterChooser.setName("filterChooser");
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(true);
    }

    protected void createNone() {
        $objectMap.put("none", none = new JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("vradi.email.noSelection"));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(_("vradi.email.bindSession"));
        searchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__searchButton"));
    }

    protected void createSendSession() {
        $objectMap.put("sendSession", sendSession = new JButton());
        
        sendSession.setName("sendSession");
        sendSession.setText(_("vradi.email.sendSession"));
        sendSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSession"));
    }

    protected void createSessionDatePicker() {
        $objectMap.put("sessionDatePicker", sessionDatePicker = new JXDatePicker());
        
        sessionDatePicker.setName("sessionDatePicker");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEmailPopupUI();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(content, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add($Table0, BorderLayout.CENTER);
        $JPanel1.add($JButton0, BorderLayout.EAST);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sessionDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(filterChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        addChildrenToContent();
        // inline complete setup of $JPanel2
        $JPanel2.add(none, BorderLayout.CENTER);
        // inline complete setup of $Table1
        $Table1.add($JButton1, new GridBagConstraints(0, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(searchButton, new GridBagConstraints(1, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sendSession, new GridBagConstraints(2, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(deleteSession, new GridBagConstraints(3, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton2, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JSplitPane0.setResizeWeight(0.1);
        filterChooser.setModel(new DefaultComboBoxModel(EmailNavigationTreeHelper.EmailFilterEnum.values()));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("search"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("new"));
        searchButton.setIcon(SwingUtil.getUIManagerActionIcon("search"));
        searchButton.setEnabled(isActiveSession());
        sendSession.setIcon(SwingUtil.getUIManagerActionIcon("send"));
        sendSession.setEnabled(canBeSend());
        deleteSession.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
        deleteSession.setEnabled(isActiveSession());
        $JButton2.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        // late initializer
        emailPopupUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("emailPopupUI", emailPopupUI);
        createContentLayout();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.session"));
        createSessionDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.filter"));
        createFilterChooser();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createContent();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createNone();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.email.newSession"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSearchButton();
        createSendSession();
        createDeleteSession();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("vradi.action.close"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of emailPopupUI
        setName("emailPopupUI");
        emailPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.email.title"));
        emailPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__emailPopupUI"));
        
        $completeSetup();
    }

}