/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.ThesaurusHighlighter;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class ThesaurusPathChooserUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected Boolean saved;
    protected JButton select;
    protected Boolean selected;
    protected JXTreeTable thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = helper.getSelectedNode();
    
                // Set as selected
                setSelected(selectedNode != null);
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
        
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
        
    protected void close(){
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI(JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        SwingUtil.initContext(this, parentContext);
            this.helper = helper;
            $initialize();
    }

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusPathChooserUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doActionPerformed__on__select(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public Boolean getSaved() {
        return saved;
    }

    public JButton getSelect() {
        return select;
    }

    public Boolean getSelected() {
        return selected;
    }

    public JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public Boolean isSaved() {
        return saved !=null && saved;
    }

    public Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(Boolean saved) {
        Boolean oldValue = this.saved;
        this.saved = saved;
        firePropertyChange(PROPERTY_SAVED, oldValue, saved);
    }

    public void setSelected(Boolean selected) {
        Boolean oldValue = this.selected;
        this.selected = selected;
        firePropertyChange(PROPERTY_SELECTED, oldValue, selected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new JButton());
        
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
        cancel.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(SwingUtil.getUIManagerActionIcon("select"));
        // late initializer
        thesaurusPathChooserUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusPathChooserUI", thesaurusPathChooserUI);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}