/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.admin.content.AdminThesaurusHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class ThesaurusEditUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MOVED = "moved";
    public static final String PROPERTY_SAVE = "save";
    public static final String PROPERTY_TITLE_THESAURUS = "titleThesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";
    public static final String BINDING_TAGS_FIELD_TEXT = "tagsField.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28TRxSemDiJE8qviIgIqEKJKFLVdQgIVQ2/KRZBBiqcSghLVcfewR60uzPMvE02F8SfAP9Be+eCxI1T1UPPPfRS9V+oqh56RX0zXu9648VZdX1Y2/Pe98333sz77Dd/kapW5MwzGkWOCgPgPnPu3Xz8+GHnGevCN0x3FZcgFBm8piqk0iYLbrKugZxtNw28HsPrt4UvRcCCEfRGk8xr2PWY7jMGQE5nEV2t660kvBHJUA1ZE1F5rD/+83fllfvypwohkUR1S1jKyn6otJLpJqlwF8gx3Gmb1j0a9FCG4kEP9X5i1m57VOsH1GfPyQsy2yQzkiokA/JZ8ZIth8VHEshh6DNNQxXqOy6H7zaBrAnVc7p9oZjvbCvqcifkDnV9HjhSyFBqZysLkdLSzQCZ7jAa4AGMMaASDpyNQEdAmm4zIEdNfY6p2bklhIdEacohRHsswQI5kiYPGpTmzvnC5U85c833o+l61RfbY4uzq1u047E1ICcyx6R3kNOxMZNZS9lX7zVph3mIOGY0RHHqYNUkLQOpWblN9hT2wi6Y75/atIRyQSiXKdNKoYCcy9HBbMx5EPqdYWKWohbglWhw5uHlWcrI2mIR2EAWENdt5ZzMr3A9kXo+3UdS6Cd0e4LzJthiHo4pkMWMilshgAiy6cN9LubtA7Snk30+zwdeygEe7Arfx8sW9+L4WC9uKkazkLgV6zmtqK3GytfMgn18PR68MBpU5GTmANFJnNRJ0lGfapOqCnEZb1573HweYWhgOyf22I4htNEPS4u/v//zXWPoNcu49/Hc1BGrRA+QSkimzDDi8A+MJgTu1e9TudEmNW0P0ProqRxhrTiM4nC/wcwauHOX6j5SVGf/+PmXpR9+O0AqDTLvCeo2qMnfxDPtK+yC8NxIXr9hFR3cmcPnEaMNyIxHdwU2lBy64lKgKx0euHhs1yJswqmcJiRKOrVf/11svb0xbMQUClv+aHrajOoTMsMDjwfM2m7sqLk2uyA1C12ROmeel06Z93kZm8sd+9zMqxSdyKUeGsiVwfYrFNDDOiEwLNag7tsqzKeHxUmt55hw8/+TTAOOyASO0/tymOXvzWMrn+FMARU1GoL41vzUTJBytgDRXHzXdycIKsJzGK/tjhWUGlkJWTVD94hpNqnVheoLNWvgjJXlmUWeFu+Vqys5+Y8wnCt9d74oreHLIjPAuxNPuF66jvIM66U7cam0hsulNXxViOH1BIarpasoxjBJw/UiA8YC8x/DLUWzXymG4T8Ej8onPw0AAA==";
    private static final Log log = LogFactory.getLog(ThesaurusEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Thesaurus bean;
    protected JTextArea commentField;
    protected Boolean modified;
    protected Boolean moved;
    protected JTextField nameField;
    protected NumberEditor orderEditor;
    protected JLabel pathField;
    protected JButton pathSelect;
    protected Boolean save;
    protected JTextField tagsField;
    protected ThesaurusEditUI thesaurusEditUI = this;
    protected String titleThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private Table $Table2;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Thesaurus thesaurus, String title, final boolean isCreating) {
        setBean(thesaurus);
        setTitleThesaurus(title);
        orderEditor.setBean(getBean());
        orderEditor.init();
        orderEditor.setModel(getBean().getOrder());
        thesaurus.addPropertyChangeListener(new PropertyChangeListener(){
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
        orderEditor.getTextField().setColumns(4);
        this.pack();
        setVisible(true);
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected AdminThesaurusHandler getHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    protected void valid(){
        setSave(true);
        close();
    }
    
    protected void close(){
        setVisible(false);
        UIHelper.saveComponentDispositionConfig();
        dispose();
    }
    
    protected void move(){
        getHandler().moveThesaurus(this, getBean());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusEditUI() {
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusEditUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        valid();
    }

    public void doActionPerformed__on__pathSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        move();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setComment(commentField.getText());
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setName(nameField.getText());
    }

    public void doKeyReleased__on__tagsField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ThesaurusDataHelper.setTagsAsString(getBean(), tagsField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Thesaurus getBean() {
        return bean;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public Boolean getModified() {
        return modified;
    }

    public Boolean getMoved() {
        return moved;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public NumberEditor getOrderEditor() {
        return orderEditor;
    }

    public JLabel getPathField() {
        return pathField;
    }

    public JButton getPathSelect() {
        return pathSelect;
    }

    public Boolean getSave() {
        return save;
    }

    public JTextField getTagsField() {
        return tagsField;
    }

    public String getTitleThesaurus() {
        return titleThesaurus;
    }

    public Boolean isModified() {
        return modified !=null && modified;
    }

    public Boolean isMoved() {
        return moved !=null && moved;
    }

    public Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Thesaurus bean) {
        Thesaurus oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setModified(Boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void setMoved(Boolean moved) {
        Boolean oldValue = this.moved;
        this.moved = moved;
        firePropertyChange(PROPERTY_MOVED, oldValue, moved);
    }

    public void setSave(Boolean save) {
        Boolean oldValue = this.save;
        this.save = save;
        firePropertyChange(PROPERTY_SAVE, oldValue, save);
    }

    public void setTitleThesaurus(String titleThesaurus) {
        String oldValue = this.titleThesaurus;
        this.titleThesaurus = titleThesaurus;
        firePropertyChange(PROPERTY_TITLE_THESAURUS, oldValue, titleThesaurus);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
        add($Table1, BorderLayout.CENTER);
        add($Table2, BorderLayout.SOUTH);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createMoved() {
        $objectMap.put("moved", moved = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createOrderEditor() {
        $objectMap.put("orderEditor", orderEditor = new NumberEditor(this));
        
        orderEditor.setName("orderEditor");
        orderEditor.setProperty("order");
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new JLabel());
        
        pathField.setName("pathField");
    }

    protected void createPathSelect() {
        $objectMap.put("pathSelect", pathSelect = new JButton());
        
        pathSelect.setName("pathSelect");
        pathSelect.setText(_("vradi.adminThesaurus.move"));
        pathSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pathSelect"));
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createTagsField() {
        $objectMap.put("tagsField", tagsField = new JTextField());
        
        tagsField.setName("tagsField");
        tagsField.setColumns(15);
        tagsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__tagsField"));
    }

    protected void createTitleThesaurus() {
        $objectMap.put("titleThesaurus", titleThesaurus = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusEditUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(orderEditor, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(nameField, new GridBagConstraints(2, 1, 2, 1, 0.9, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pathField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pathSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(tagsField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(commentField, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setTitle(_(titleThesaurus));
        orderEditor.setAutoPopup(false);
        orderEditor.setShowPopupButton(false);
        orderEditor.setShowReset(true);
        orderEditor.setUseFloat(false);
        orderEditor.setUseSign(false);
        pathSelect.setIcon(SwingUtil.getUIManagerActionIcon("move"));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("save"));
        // late initializer
        thesaurusEditUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusEditUI", thesaurusEditUI);
        createBean();
        createSave();
        createTitleThesaurus();
        createModified();
        createMoved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminThesaurus.orderName"));
        createOrderEditor();
        createNameField();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminThesaurus.path"));
        createPathField();
        createPathSelect();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminThesaurus.tags"));
        createTagsField();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminThesaurus.comment"));
        createCommentField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.save"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusEditUI
        setName("thesaurusEditUI");
        thesaurusEditUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"titleThesaurus") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getTitleThesaurus()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(nameField, getBean().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                pathField.setText(_(ThesaurusDataHelper.getParentPath(getBean(), "/")));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TAGS_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(tagsField, ThesaurusDataHelper.getTagsAsString(getBean()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(commentField, getBean().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isModified());
            }
        });
    }

}