/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.admin.content.AdminThesaurusHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import static org.nuiton.i18n.I18n._;

public class ThesaurusConfirmDialogUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_SAVE = "save";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MSG_LABEL_TEXT = "msgLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+LbSlxR8oASGCAeHiwS3EiwZUfoUIqZoIJsRenO2O7ZDdnXFmFpaL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7ZXbqtLNiEHqbtvPd973tvvvf2BxSUhOldEoaWDHzNPGptLu/sPLR3aUOvUdWQTGguIf7k8pCvw6DTvlcaZuo1A68m8Ooq9wT3qd+BXqhBRekDl6oWpVrDZDeioVR1qx1eCEUgD1nborJYX//6mX/lvHyTBwgFqqtgK1P/Q6Wd9NcgzxwNF7HSHqm6xG+iDMn8Juo9a+5WXaLUA+LR5/ACSjUoCiKRTMPV3luOOCJ8KDSM6RZVJJCBWuX+Mya9NUZc3ny8oeEWl02r0eKSetaeJA6zAmYRx2O+JbgIhLK2j8EKERUoaujzVFPDkNFumX6suJ80od+mxMc3O1ILxTPNaEeRDpAie1TDhZR2hXMXidKU0uw2sV06hx12PYDax/JWFDOZ5TZgAJXWiE1dnL/hDZPUzejSJI20c8uqxfeXhXAPNAx3Ja8EWnO/OzuRMm/+XuouWp5NEHPmYtIcV44G5zuDEi53NYRetVKvpmbK1aEgA7zGCdSP2vsRhmJjj/1jbEMYRf+MDn/98P39+qGby1h7JDO1YxnRZUJyQaV5Ow3nYysHmrnV+0Qs1JGFurjJ0aZOZAjbSsIoDuvFT2zg1j2iWkhRKH37+Gn06Zc+yK9DxeXEWScmfwPKuiVxCtx1QnF3KVJ0Zn8AzyGjTUPRJQccBwrnFh2iyZTNfAcf7U6IQ5jIGEJbiV3+/Ht4693S4SByKGz82PR0GIUnUGS+y3waLXays5mLPCgUDRye7mbWtubMd0UkJr8WndezOi143CHGyItx+Smice3sQFNs1qDmoy7Mrxs9k/azRuzsuWyO8V44NA31qTjM9Yo5bmYzTPTEcPsEDdOn1tAbw0kaZk6twTD8BSJ5uWNNBwAA";
    private static final Log log = LogFactory.getLog(ThesaurusConfirmDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Thesaurus bean;
    protected String msg;
    protected JLabel msgLabel;
    protected Boolean save;
    protected JButton showApply;
    protected ThesaurusConfirmDialogUI thesaurusConfirmDialogUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private Table $Table1;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusHandler getHandler() {
        return getContextValue(AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    public void init(Thesaurus thesaurus, String msg, String title) {
        setBean(thesaurus);
        setTitle(title);
        setMsg(msg);
    
        this.pack();
        setVisible(true);
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void showApply() {
        getHandler().showApply(this, getBean());
    }
    
    protected void saveAndClose() {
        setSave(true);
        close();
    }
    
    protected void close() {
       setVisible(false);
       UIHelper.saveComponentDispositionConfig();
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusConfirmDialogUI() {
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveAndClose();
    }

    public void doActionPerformed__on__showApply(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showApply();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Thesaurus getBean() {
        return bean;
    }

    public String getMsg() {
        return msg;
    }

    public JLabel getMsgLabel() {
        return msgLabel;
    }

    public Boolean getSave() {
        return save;
    }

    public JButton getShowApply() {
        return showApply;
    }

    public Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Thesaurus bean) {
        Thesaurus oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMsg(String msg) {
        String oldValue = this.msg;
        this.msg = msg;
        firePropertyChange(PROPERTY_MSG, oldValue, msg);
    }

    public void setSave(Boolean save) {
        Boolean oldValue = this.save;
        this.save = save;
        firePropertyChange(PROPERTY_SAVE, oldValue, save);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusConfirmDialogUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createMsg() {
        $objectMap.put("msg", msg = "");
    }

    protected void createMsgLabel() {
        $objectMap.put("msgLabel", msgLabel = new JLabel());
        
        msgLabel.setName("msgLabel");
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createShowApply() {
        $objectMap.put("showApply", showApply = new JButton());
        
        showApply.setName("showApply");
        showApply.setText(_("vradi.thesaurus.showApply"));
        showApply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showApply"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusConfirmDialogUI();
        // inline complete setup of $Table0
        $Table0.add(msgLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(showApply, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        msgLabel.setIcon(UIManager.getLookAndFeelDefaults().getIcon("OptionPane.warningIcon"));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("save"));
        // late initializer
        thesaurusConfirmDialogUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusConfirmDialogUI", thesaurusConfirmDialogUI);
        createMsg();
        createBean();
        createSave();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMsgLabel();
        createShowApply();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.thesaurus.confirm.save"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusConfirmDialogUI
        setName("thesaurusConfirmDialogUI");
        thesaurusConfirmDialogUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_TEXT, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setText(_(getMsg()));
            }
        });
    }

}