/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferListColumnFactory;
import org.chorem.vradi.ui.offer.OfferTable;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.search.PaginationUI;
import org.chorem.vradi.ui.search.SearchHandler;
import org.chorem.vradi.ui.search.SearchUI;
import static org.nuiton.i18n.I18n._;

public class AdminRequestUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_SAVE = "canSave";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALID_BUTTON_VISIBLE = "validButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminRequestUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminRequestUI adminRequestUI = this;
    protected Boolean canSave;
    protected JButton closeButton;
    protected OfferListColumnFactory offerListColumnFactory;
    protected PaginationUI paginationUI;
    protected String request;
    protected OfferTable resultTable;
    protected OfferListTableModel resultTableModel;
    protected JPanel searchPanel;
    protected JButton validButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        registerDataBinding(djb);
        djb.applyDataBinding();
        
        validate();
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void saveAndClose() {
        setRequest(getSearchUI().getRequest());
        close();
    }
    
    protected void close() {
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminRequestUI() {
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminRequestUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doActionPerformed__on__validButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getCanSave() {
        return canSave;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public String getRequest() {
        return request;
    }

    public OfferTable getResultTable() {
        return resultTable;
    }

    public OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public JPanel getSearchPanel() {
        return searchPanel;
    }

    public JButton getValidButton() {
        return validButton;
    }

    public Boolean isCanSave() {
        return canSave !=null && canSave;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanSave(Boolean canSave) {
        Boolean oldValue = this.canSave;
        this.canSave = canSave;
        firePropertyChange(PROPERTY_CAN_SAVE, oldValue, canSave);
    }

    public void setOfferListColumnFactory(OfferListColumnFactory offerListColumnFactory) {
        OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = offerListColumnFactory;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, offerListColumnFactory);
    }

    public void setRequest(String request) {
        String oldValue = this.request;
        this.request = request;
        firePropertyChange(PROPERTY_REQUEST, oldValue, request);
    }

    public void setResultTableModel(OfferListTableModel resultTableModel) {
        OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = resultTableModel;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, resultTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminRequestUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createCanSave() {
        $objectMap.put("canSave", canSave = true);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("vradi.common.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createRequest() {
        $objectMap.put("request", request = null);
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createValidButton() {
        $objectMap.put("validButton", validButton = new JButton());
        
        validButton.setName("validButton");
        validButton.setText(_("vradi.adminRequest.valid"));
        validButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAdminRequestUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add(closeButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(validButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setShowGrid(true);
        closeButton.setIcon(SwingUtil.getUIManagerActionIcon("close"));
        validButton.setIcon(SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        adminRequestUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminRequestUI", adminRequestUI);
        createRequest();
        createCanSave();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createCloseButton();
        createValidButton();
        // inline creation of adminRequestUI
        setName("adminRequestUI");
        adminRequestUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.adminRequest.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_BUTTON_VISIBLE, true ,"canSave") {
        
            @Override
            public void processDataBinding() {
                validButton.setVisible(isCanSave());
            }
        });
    }

}