/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormImpl;
import org.chorem.vradi.entities.Infogene;
import org.chorem.vradi.entities.InfogeneImpl;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.models.FieldSelectModel;
import org.chorem.vradi.ui.admin.models.TemplateFieldTableModel;
import org.chorem.vradi.ui.admin.popups.TemplateFieldBindingUI;
import org.chorem.vradi.ui.admin.widget.FieldSelectUI;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyI18nImpl;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18n;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AdminFormTypeUI extends AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminFormTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected WikittyExtension bean;
    protected CardLayout2 cardLayout;
    protected JPanel cardPanel;
    protected VBox content;
    protected JButton createField;
    protected JButton createForm;
    protected JButton downloadTemplate;
    protected Table fieldListUI;
    protected TemplateFieldTableModel fieldsModel;
    protected HidorButton hidorInfogene;
    protected JPanel infogene;
    protected HBox lastModified;
    protected JButton newTemplate;
    protected JButton templateBindingButton;
    protected JComboBox templateChoice;
    protected JButton templateExampleButton;
    protected JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JPanel $JPanel1;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected WikittyI18n wikittyI18n;
    
    
    public WikittyI18n getWikittyI18n() {
        return wikittyI18n;
    }
    
    public void setWikittyI18n(WikittyI18n wikittyI18n) {
        this.wikittyI18n = wikittyI18n;
    }
    
    @Override
    protected void postLoadBean() {
    
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        if (bean == null) {
            return;
        }
    
        // Update template choice
        templateChoice.setModel(getHandler().getTemplateComboBoxModel(bean));
    
        // Select template
        templateChoice.setSelectedItem(getHandler().getFormTypeTemplateName(bean));
    
        // Fill other fields that infogene
        int i = 0;
        Collection<String> fieldNames = bean.getFieldNames();
    
        // Get traduction for extension
        wikittyI18n = WikittyI18nUtil.getI18n(VradiService.getWikittyProxy(), bean);
    
        for (String fieldName : fieldNames) {
            FieldType fieldType = bean.getFieldType(fieldName);
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldType, wikittyI18n, i);
            create(fieldSelectModel, false);
            i = i + 1;
        }
        fillInfogenePanel();
        setModified(false);
        validate();
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this, getHelper());
        setModified(false);
    }
    
    @Override
    protected void clearUI() {
        content.removeAll();
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()), false);
    }
    
    protected FieldSelectUI create(FieldSelectModel fieldSelectModel, boolean isInfogene){
        FieldSelectUI result = new FieldSelectUI(this);
    
        result.updateBean(fieldSelectModel);
        result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                FieldSelectUI field = (FieldSelectUI) evt.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                }
                setModified(true);
                if(evt.getNewValue() == null) {
    
                    if(field != null) {
                        field.setVisible(false);
                        content.remove(field);
                    }
                    if(field.getBean().isUpOrDown() != null) {
                        if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                            content.add(field, 0);
                        } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                            content.add(field);
                        } else {
                            int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition();
                            int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                            FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                            if (log.isDebugEnabled()) {
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
                            }
    
                            content.add(field, fieldToAddPosition);
                            for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                fieldSelectUI.getBean().setPosition(i);
                                if (log.isDebugEnabled()) {
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                        }
                        field.getBean().setUpOrDown(null);
                        field.setVisible(true);
                    }
                    content.validate();
                }
            }
        });
        result.setModified(false);
        result.setInfogene(isInfogene);
    
        content.add(result);
        validate();
    
        return result;
    }
    
    private void fillInfogenePanel() {
        infogene.removeAll();
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fqFieldNames = new ArrayList<String>();
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_ID);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_OBJET);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_DESCRIPTION);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_CREATIONDATE);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_ENTITY);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCETEXT);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCEURL);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_COUNTRY);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_DEPARTMENT);
        fillInfogenePanel(fqFieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fqFieldNames.clear();
        fqFieldNames.add(Form.FQ_FIELD_FORM_DATEPUB);
        fqFieldNames.add(Form.FQ_FIELD_FORM_DATEPEREMPTION);
        fillInfogenePanel(fqFieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fqFieldNames,
                                   WikittyExtension extension, int i) {
    
        for (String fqFieldName : fqFieldNames) {
            FieldType fieldType = extension.getFieldType(WikittyUtil.getFieldNameFromFQFieldName(fqFieldName));
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fqFieldName, fieldType, null, i);
    
            FieldSelectUI fieldDisplayUI = create(fieldSelectModel, true);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (String) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
        setFieldsModel(templateFieldBindingUI.getFieldsModel());
        if (getFieldsModel() != null) {
            setModified(true);
        }
    }
    
    protected void addNewTemplate() {
        if (getHandler().uploadNewTemplate(this)) {
            openTemplateFieldBindingUI();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminFormTypeUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminFormTypeUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminFormTypeUI() {
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        create();
    }

    public void doActionPerformed__on__createForm(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__downloadTemplate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().downloadTemplate(this);
    }

    public void doActionPerformed__on__hidorInfogene(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addNewTemplate();
    }

    public void doActionPerformed__on__templateBindingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public WikittyExtension getBean() {
        return bean;
    }

    public CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public JPanel getCardPanel() {
        return cardPanel;
    }

    public VBox getContent() {
        return content;
    }

    public JButton getCreateField() {
        return createField;
    }

    public JButton getCreateForm() {
        return createForm;
    }

    public JButton getDownloadTemplate() {
        return downloadTemplate;
    }

    public Table getFieldListUI() {
        return fieldListUI;
    }

    public TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public JPanel getInfogene() {
        return infogene;
    }

    public HBox getLastModified() {
        return lastModified;
    }

    public JButton getNewTemplate() {
        return newTemplate;
    }

    public JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(WikittyExtension bean) {
        WikittyExtension oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setFieldsModel(TemplateFieldTableModel fieldsModel) {
        TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = fieldsModel;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, fieldsModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new JPanel());
        
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new VBox());
        
        content.setName("content");
    }

    protected void createCreateField() {
        $objectMap.put("createField", createField = new JButton());
        
        createField.setName("createField");
        createField.setText(_("vradi.adminField.new"));
        createField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createField"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new JButton());
        
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createDownloadTemplate() {
        $objectMap.put("downloadTemplate", downloadTemplate = new JButton());
        
        downloadTemplate.setName("downloadTemplate");
        downloadTemplate.setText(_("vradi.adminFormType.template.download"));
        downloadTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downloadTemplate"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new Table());
        
        fieldListUI.setName("fieldListUI");
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = null);
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new HidorButton());
        
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new JPanel());
        
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new JButton());
        
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new JButton());
        
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new JComboBox());
        
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new JButton());
        
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        toolbar.setLayout(
          new BoxLayout(toolbar, 0)
        );
        toolbar.putClientProperty("help", 
        "ui.main.toolbar"
        );
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(createField);
        $JPanel0.add(hidorInfogene, BorderLayout.WEST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(downloadTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
        createField.setIcon(SwingUtil.getUIManagerActionIcon("add"));
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        title.setHorizontalTextPosition(
          JLabel . LEFT
        );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AdminContentUI0", $AdminContentUI0);
        createBean();
        createCardLayout();
        createFieldsModel();
        createTitle();
        createCreateForm();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminForm.deleteFormType"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateField();
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createDownloadTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(
          new BoxLayout(toolbar, 0)
        );
        
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
    }

}