/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AdminClientUI extends AdminContentUI<Client> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminClientUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table adminClientForm;
    protected Client bean;
    protected JTextField clientAddress;
    protected JTextField clientContact;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "clientName")
    protected JTextField clientName;
    protected JTextField clientPhone;
    protected JButton createButton;
    protected Boolean inGroup;
    protected JLabel title;
    @Validator( validatorId = "validator")
    protected SwingValidator<Client> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private JPanel $JPanel0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JButton $JButton2;
    private JLabel $JLabel2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    }
    
    @Override
    public void save() {
    
        Client client = getHandler().saveClient(this, getHelper(), bean, null);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(client);
    
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        clientName.setText("");
        clientAddress.setText("");
        clientPhone.setText("");
        clientContact.setText("");
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminClientUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminClientUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminClientUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminClientUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminClientUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminClientUI() {
        $initialize();
    }

    public AdminClientUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createUser(this, getHelper().getClientSelected());
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createClient(this);                                 setModified(true);
    }

    public void doKeyReleased__on__clientAddress(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(clientName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__clientPhone(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getAdminClientForm() {
        return adminClientForm;
    }

    public Client getBean() {
        return bean;
    }

    public JTextField getClientAddress() {
        return clientAddress;
    }

    public JTextField getClientContact() {
        return clientContact;
    }

    public JTextField getClientName() {
        return clientName;
    }

    public JTextField getClientPhone() {
        return clientPhone;
    }

    public JButton getCreateButton() {
        return createButton;
    }

    public Boolean getInGroup() {
        return inGroup;
    }

    public JLabel getTitle() {
        return title;
    }

    public SwingValidator<Client> getValidator() {
        return validator;
    }

    public Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Client bean) {
        Client oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setInGroup(Boolean inGroup) {
        Boolean oldValue = this.inGroup;
        this.inGroup = inGroup;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, inGroup);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new Table());
        
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new JTextField());
        
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new JTextField());
        
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new JTextField());
        
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new JTextField());
        
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminClient.createClient"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        toolbar.setLayout(
          new BoxLayout(toolbar, 0)
        );
        toolbar.putClientProperty("help", 
        "ui.main.toolbar"
        );
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Client.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        createButton.setIcon(SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("client.delete"));
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton2.setIcon(SwingUtil.getUIManagerActionIcon("site"));
        title.setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        title.setHorizontalTextPosition(
          JLabel . LEFT
        );
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AdminContentUI0", $AdminContentUI0);
        createBean();
        createInGroup();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createAdminClientForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(
          new BoxLayout(toolbar, 0)
        );
        
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(clientName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(clientAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(clientPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_CONTACT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(clientContact, getBean().getContact());
                }
            }
        });
    }

}