/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.NamedParser;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

abstract class Double2Parser
extends NamedParser {
    public Double2Parser(String name) {
        super(name);
    }

    public abstract double func(int var1, DocValues var2, DocValues var3);

    public ValueSource parse(FunctionQParser fp) throws ParseException {
        return new Function(fp.parseValueSource(), fp.parseValueSource());
    }

    class Function
    extends ValueSource {
        private final ValueSource a;
        private final ValueSource b;

        public Function(ValueSource a, ValueSource b) {
            this.a = a;
            this.b = b;
        }

        public String description() {
            return Double2Parser.this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
        }

        public DocValues getValues(Map context, IndexReader reader) throws IOException {
            final DocValues aVals = this.a.getValues(context, reader);
            final DocValues bVals = this.b.getValues(context, reader);
            return new DocValues(){

                public float floatVal(int doc) {
                    return (float)this.doubleVal(doc);
                }

                public int intVal(int doc) {
                    return (int)this.doubleVal(doc);
                }

                public long longVal(int doc) {
                    return (long)this.doubleVal(doc);
                }

                public double doubleVal(int doc) {
                    return Double2Parser.this.func(doc, aVals, bVals);
                }

                public String strVal(int doc) {
                    return Double.toString(this.doubleVal(doc));
                }

                public String toString(int doc) {
                    return Double2Parser.this.name() + '(' + aVals.toString(doc) + ',' + bVals.toString(doc) + ')';
                }
            };
        }

        public void createWeight(Map context, Searcher searcher) throws IOException {
            this.a.createWeight(context, searcher);
            this.b.createWeight(context, searcher);
        }

        public int hashCode() {
            int h = this.a.hashCode();
            h ^= h << 13 | h >>> 20;
            h += this.b.hashCode();
            h ^= h << 23 | h >>> 10;
            return h += Double2Parser.this.name().hashCode();
        }

        public boolean equals(Object o) {
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Function other = (Function)o;
            return this.a.equals(other.a) && this.b.equals(other.b);
        }
    }
}

