/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate;

import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.SubordinateAtomicAction;
import com.arjuna.ats.jta.exceptions.InvalidTerminationStateException;
import com.arjuna.ats.jta.exceptions.UnexpectedConditionException;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class TransactionImple
extends com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple {
    public TransactionImple(int timeout) {
        this(new SubordinateAtomicAction(timeout));
    }

    public TransactionImple(AtomicAction act) {
        super(act);
        TransactionImple.putTransaction(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.equals");
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionImple) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.invalidstate"));
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        throw new InvalidTerminationStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.invalidstate"));
    }

    public int doPrepare() {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                this._theTransaction.preventCommit();
            }
            int res = subAct.doPrepare();
            switch (res) {
                case 1: 
                case 2: {
                    TransactionImple.removeTransaction(this);
                }
            }
            return res;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return 11;
        }
    }

    public void doCommit() throws IllegalStateException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            int res = subAct.doCommit();
            switch (res) {
                case 6: 
                case 7: 
                case 12: {
                    TransactionImple.removeTransaction(this);
                    break;
                }
                case 2: 
                case 4: {
                    throw new HeuristicRollbackException();
                }
                case 11: {
                    throw new HeuristicRollbackException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                case 9: {
                    TransactionImple.removeTransaction(this);
                    throw new IllegalStateException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
    }

    public void doRollback() throws IllegalStateException, HeuristicMixedException, HeuristicCommitException, HeuristicRollbackException, SystemException {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            if (!this.endSuspendedRMs() && jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.endsuspendfailed1");
            }
            int res = subAct.doRollback();
            switch (res) {
                case 2: 
                case 4: {
                    TransactionImple.removeTransaction(this);
                    break;
                }
                case 11: {
                    throw new HeuristicRollbackException();
                }
                case 12: {
                    throw new HeuristicCommitException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
    }

    public void doForget() throws IllegalStateException {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            subAct.doForget();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    public void doOnePhaseCommit() throws IllegalStateException, HeuristicMixedException, SystemException, RollbackException {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                this._theTransaction.preventCommit();
            }
            int status = subAct.doOnePhaseCommit();
            switch (status) {
                case 6: 
                case 7: 
                case 12: {
                    TransactionImple.removeTransaction(this);
                    break;
                }
                case 2: 
                case 4: 
                case 11: {
                    TransactionImple.removeTransaction(this);
                    throw new RollbackException();
                }
                case 9: {
                    throw new InvalidTerminationStateException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
    }

    public boolean doBeforeCompletion() throws SystemException {
        try {
            SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
            return subAct.doBeforeCompletion();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
    }

    @Override
    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < ac-subordinate, NoTransaction >";
        }
        return "TransactionImple < ac-subordinate, " + this._theTransaction + " >";
    }

    @Override
    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new InvalidTerminationStateException();
    }

    @Override
    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, SystemException {
        throw new InvalidTerminationStateException();
    }

    public boolean activated() {
        return true;
    }
}

