/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.SyncFailedException;

public abstract class ObjectStore {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_COMMITTED = 1;
    public static final int OS_UNCOMMITTED = 2;
    public static final int OS_HIDDEN = 4;
    public static final int OS_COMMITTED_HIDDEN = 5;
    public static final int OS_UNCOMMITTED_HIDDEN = 6;
    public static final int OS_SHADOW = 10;
    public static final int OS_ORIGINAL = 11;
    public static final int OS_INVISIBLE = 12;
    public static final int OS_SHARED = 13;
    public static final int OS_UNSHARED = 14;
    protected int shareStatus = arjPropertyManager.getObjectStoreEnvironmentBean().getShare();
    private String _objectStoreRoot = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
    private String _objectStoreDir = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir();

    public abstract int typeIs();

    public abstract boolean allObjUids(String var1, InputObjectState var2, int var3) throws ObjectStoreException;

    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this.allObjUids(s, buff, 0);
    }

    public abstract boolean allTypes(InputObjectState var1) throws ObjectStoreException;

    public abstract int currentState(Uid var1, String var2) throws ObjectStoreException;

    public abstract String getStoreName();

    public abstract boolean commit_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean hide_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean reveal_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract InputObjectState read_committed(Uid var1, String var2) throws ObjectStoreException;

    public abstract InputObjectState read_uncommitted(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean remove_committed(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean remove_uncommitted(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean write_committed(Uid var1, String var2, OutputObjectState var3) throws ObjectStoreException;

    public abstract boolean write_uncommitted(Uid var1, String var2, OutputObjectState var3) throws ObjectStoreException;

    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public String locateStore(String localOSRoot) throws ObjectStoreException {
        if (this._objectStoreRoot == null) {
            this._objectStoreRoot = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
        }
        if (this._objectStoreDir == null) {
            this._objectStoreDir = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir();
            if (this._objectStoreDir == null || this._objectStoreDir.length() == 0) {
                throw new ObjectStoreException("object store location property not set.");
            }
            if (!this._objectStoreDir.endsWith(File.separator)) {
                this._objectStoreDir = this._objectStoreDir + File.separator;
            }
            this._objectStoreDir = this._objectStoreDir + this.getClass().getSimpleName();
        }
        String toReturn = null;
        if (localOSRoot == null || localOSRoot.length() == 0) {
            localOSRoot = this._objectStoreRoot != null && this._objectStoreRoot.length() > 0 ? this._objectStoreRoot : "defaultStore" + File.separator;
        }
        if (localOSRoot != null && localOSRoot.length() > 0) {
            toReturn = this._objectStoreDir + File.separator + localOSRoot;
        }
        if (!toReturn.endsWith(File.separator)) {
            toReturn = toReturn + File.separator;
        }
        return toReturn;
    }

    public boolean fullCommitNeeded() {
        return true;
    }

    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    public void initialise(Uid u, String tn) {
    }

    public void pack(OutputBuffer buff) throws IOException {
    }

    public void unpack(InputBuffer buff) throws IOException {
    }

    public final int shareState() {
        return this.shareStatus;
    }

    public final String storeDir() {
        return this._objectStoreDir;
    }

    public final String storeRoot() {
        return this._objectStoreRoot;
    }

    protected ObjectStore() {
        this(13);
    }

    protected ObjectStore(int ss) {
        this.shareStatus = ss;
    }

    protected abstract boolean supressEntry(String var1);

    protected String revealedId(String name) {
        return name;
    }

    public static void printStateStatus(PrintWriter strm, int res) {
        strm.print(ObjectStore.stateStatusString(res));
    }

    public static String stateStatusString(int res) {
        switch (res) {
            case 0: {
                return "ObjectStore.OS_UNKNOWN";
            }
            case 1: {
                return "ObjectStore.OS_COMMITTED";
            }
            case 2: {
                return "ObjectStore.OS_UNCOMMITTED";
            }
            case 4: {
                return "ObjectStore.OS_HIDDEN";
            }
            case 5: {
                return "ObjectStore.OS_COMMITTED_HIDDEN";
            }
            case 6: {
                return "ObjectStore.OS_UNCOMMITTED_HIDDEN";
            }
        }
        return "Unknown";
    }

    public static void printStateType(PrintWriter strm, int res) {
        strm.print(ObjectStore.stateTypeString(res));
    }

    public static String stateTypeString(int res) {
        switch (res) {
            case 10: {
                return "ObjectStore.OS_SHADOW";
            }
            case 11: {
                return "ObjectStore.OS_ORIGINAL";
            }
            case 12: {
                return "ObjectStore.OS_INVISIBLE";
            }
        }
        return "Unknown";
    }
}

