package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class WebHarvestStreamAbstract extends BusinessEntityImpl implements WebHarvestStream {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWebHarvestStream;
    /**
     * getScriptUrl :
     * @return String 
     */

    @Override
    public String getScriptUrl() {
        String value = WebHarvestStreamHelper.getScriptUrl(getWikitty());
        return value;
}

    /**
     * setScriptUrl :
     * @param scriptUrl 
     */

    @Override
    public void setScriptUrl(String scriptUrl) {
        String oldValue = getScriptUrl();
        WebHarvestStreamHelper.setScriptUrl(getWikitty(), scriptUrl);
        getPropertyChangeSupport().firePropertyChange(WebHarvestStream.FIELD_WEBHARVESTSTREAM_SCRIPTURL, oldValue, getScriptUrl());
}

    /**
     * getUrl :
     * @return String 
     */

    public String getUrl() {
        String value = XmlStreamHelper.getUrl(getWikitty());
        return value;
}

    /**
     * setUrl :
     * @param url 
     */

    public void setUrl(String url) {
        String oldValue = getUrl();
        XmlStreamHelper.setUrl(getWikitty(), url);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_URL, oldValue, getUrl());
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        String value = XmlStreamHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    public void setName(String name) {
        String oldValue = getName();
        XmlStreamHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_NAME, oldValue, getName());
}

    /**
     * getFormTypeName :
     * @return String 
     */

    public String getFormTypeName() {
        String value = XmlStreamHelper.getFormTypeName(getWikitty());
        return value;
}

    /**
     * setFormTypeName :
     * @param formTypeName 
     */

    public void setFormTypeName(String formTypeName) {
        String oldValue = getFormTypeName();
        XmlStreamHelper.setFormTypeName(getWikitty(), formTypeName);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_FORMTYPENAME, oldValue, getFormTypeName());
}

    /**
     * getImportTime :
     * @return String 
     */

    public String getImportTime() {
        String value = XmlStreamHelper.getImportTime(getWikitty());
        return value;
}

    /**
     * setImportTime :
     * @param importTime 
     */

    public void setImportTime(String importTime) {
        String oldValue = getImportTime();
        XmlStreamHelper.setImportTime(getWikitty(), importTime);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_IMPORTTIME, oldValue, getImportTime());
}

    /**
     * getAutoAssign :
     * @return boolean 
     */

    public boolean getAutoAssign() {
        boolean value = XmlStreamHelper.getAutoAssign(getWikitty());
        return value;
}

    /**
     * setAutoAssign :
     * @param autoAssign 
     */

    public void setAutoAssign(boolean autoAssign) {
        boolean oldValue = getAutoAssign();
        XmlStreamHelper.setAutoAssign(getWikitty(), autoAssign);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_AUTOASSIGN, oldValue, getAutoAssign());
}

    /**
     * getXmlFieldBinding :
     * @return Set<String> 
     */

    public Set<String> getXmlFieldBinding() {
        Set<String> result = XmlStreamHelper.getXmlFieldBinding(getWikitty());
        return result;
}

    /**
     * setXmlFieldBinding :
     * @param xmlFieldBinding 
     */

    public void setXmlFieldBinding(Set<String> xmlFieldBinding) {
        Set<String> oldValue = getXmlFieldBinding();
        XmlStreamHelper.setXmlFieldBinding(getWikitty(), xmlFieldBinding);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, oldValue, getXmlFieldBinding());
}

    /**
     * addAllXmlFieldBinding :
     * @param xmlFieldBinding 
     */

    public void addAllXmlFieldBinding(Set<String> xmlFieldBinding) {
        Set<String> oldValue = getXmlFieldBinding();
        XmlStreamHelper.addAllXmlFieldBinding(getWikitty(), xmlFieldBinding);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, oldValue, getXmlFieldBinding());
}

    /**
     * addXmlFieldBinding :
     * @param element 
     */

    public void addXmlFieldBinding(String element) {
        XmlStreamHelper.addXmlFieldBinding(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
}

    /**
     * removeXmlFieldBinding :
     * @param element 
     */

    public void removeXmlFieldBinding(String element) {
        XmlStreamHelper.removeXmlFieldBinding(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
}

    /**
     * clearXmlFieldBinding :
     */

    public void clearXmlFieldBinding() {
        XmlStreamHelper.clearXmlFieldBinding(getWikitty());
        getPropertyChangeSupport().firePropertyChange(XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
}

    /**
     * WebHarvestStreamAbstract :
     */

    public WebHarvestStreamAbstract() {
        super();
}

    /**
     * WebHarvestStreamAbstract :
     * @param wikitty 
     */

    public WebHarvestStreamAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WebHarvestStreamAbstract :
     * @param businessEntityImpl 
     */

    public WebHarvestStreamAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWebHarvestStream =
                new WikittyExtension(EXT_WEBHARVESTSTREAM,
                                     "1.0", // version
                                     XmlStream.EXT_XMLSTREAM,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String scriptUrl unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(XmlStreamAbstract.extensions); 
        // current after requires ones

        exts.add(extensionWebHarvestStream);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WebHarvestStreamAbstract
