package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class SessionAbstract extends BusinessEntityImpl implements Session {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSession;
    /**
     * getSessionDate :
     * @return Date 
     */

    @Override
    public Date getSessionDate() {
        Date value = SessionHelper.getSessionDate(getWikitty());
        return value;
}

    /**
     * setSessionDate :
     * @param sessionDate 
     */

    @Override
    public void setSessionDate(Date sessionDate) {
        Date oldValue = getSessionDate();
        SessionHelper.setSessionDate(getWikitty(), sessionDate);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SESSIONDATE, oldValue, getSessionDate());
}

    /**
     * getNum :
     * @return int 
     */

    @Override
    public int getNum() {
        int value = SessionHelper.getNum(getWikitty());
        return value;
}

    /**
     * setNum :
     * @param num 
     */

    @Override
    public void setNum(int num) {
        int oldValue = getNum();
        SessionHelper.setNum(getWikitty(), num);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_NUM, oldValue, getNum());
}

    /**
     * getStatus :
     * @return int 
     */

    @Override
    public int getStatus() {
        int value = SessionHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    @Override
    public void setStatus(int status) {
        int oldValue = getStatus();
        SessionHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_STATUS, oldValue, getStatus());
}

    /**
     * getParagraph :
     * @return String 
     */

    @Override
    public String getParagraph() {
        String value = SessionHelper.getParagraph(getWikitty());
        return value;
}

    /**
     * setParagraph :
     * @param paragraph 
     */

    @Override
    public void setParagraph(String paragraph) {
        String oldValue = getParagraph();
        SessionHelper.setParagraph(getWikitty(), paragraph);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_PARAGRAPH, oldValue, getParagraph());
}

    /**
     * getSessionLogs :
     * @return String 
     */

    @Override
    public String getSessionLogs() {
        String value = SessionHelper.getSessionLogs(getWikitty());
        return value;
}

    /**
     * setSessionLogs :
     * @param sessionLogs 
     */

    @Override
    public void setSessionLogs(String sessionLogs) {
        String oldValue = getSessionLogs();
        SessionHelper.setSessionLogs(getWikitty(), sessionLogs);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SESSIONLOGS, oldValue, getSessionLogs());
}

    /**
     * getFiles :
     * @return Set<String> 
     */

    @Override
    public Set<String> getFiles() {
        Set<String> result = SessionHelper.getFiles(getWikitty());
        return result;
}

    /**
     * setFiles :
     * @param files 
     */

    @Override
    public void setFiles(Set<String> files) {
        Set<String> oldValue = getFiles();
        SessionHelper.setFiles(getWikitty(), files);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_FILES, oldValue, getFiles());
}

    /**
     * addAllFiles :
     * @param files 
     */

    @Override
    public void addAllFiles(Set<String> files) {
        Set<String> oldValue = getFiles();
        SessionHelper.addAllFiles(getWikitty(), files);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_FILES, oldValue, getFiles());
}

    /**
     * addFiles :
     * @param element 
     */

    @Override
    public void addFiles(String element) {
        SessionHelper.addFiles(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_FILES, null, getFiles());
}

    /**
     * removeFiles :
     * @param element 
     */

    @Override
    public void removeFiles(String element) {
        SessionHelper.removeFiles(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_FILES, null, getFiles());
}

    /**
     * clearFiles :
     */

    @Override
    public void clearFiles() {
        SessionHelper.clearFiles(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_FILES, null, getFiles());
}

    /**
     * getSending :
     * @return Set<String> 
     */

    @Override
    public Set<String> getSending() {
        Set<String> result = SessionHelper.getSending(getWikitty());
        return result;
}

    /**
     * setSending :
     * @param sending 
     */

    @Override
    public void setSending(Set<String> sending) {
        Set<String> oldValue = getSending();
        SessionHelper.setSending(getWikitty(), sending);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, oldValue, getSending());
}

    /**
     * addAllSending :
     * @param sending 
     */

    @Override
    public void addAllSending(Set<String> sending) {
        Set<String> oldValue = getSending();
        SessionHelper.addAllSending(getWikitty(), sending);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, oldValue, getSending());
}

    /**
     * addSending :
     * @param element 
     */

    @Override
    public void addSending(String element) {
        SessionHelper.addSending(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * removeSending :
     * @param element 
     */

    @Override
    public void removeSending(String element) {
        SessionHelper.removeSending(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * clearSending :
     */

    @Override
    public void clearSending() {
        SessionHelper.clearSending(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * SessionAbstract :
     */

    public SessionAbstract() {
        super();
}

    /**
     * SessionAbstract :
     * @param wikitty 
     */

    public SessionAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * SessionAbstract :
     * @param businessEntityImpl 
     */

    public SessionAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionSession =
                new WikittyExtension(EXT_SESSION,
                                     "5.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date sessionDate unique=\"true\"", 
                                             "Numeric num unique=\"true\"", 
                                             "Numeric status unique=\"true\"", 
                                             "String paragraph unique=\"true\"", 
                                             "String sessionLogs unique=\"true\"", 
                                             "String files[0-*] unique=\"true\"", 
                                             "Wikitty sending[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionSession);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //SessionAbstract
