/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api.model;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.chorem.pollen.votecounting.api.model.SimpleVoter;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;

public class ListOfVoter
implements Voter,
Iterable<Voter> {
    private static final long serialVersionUID = 1L;
    private final SimpleVoter rootVoter = SimpleVoter.newVoter(null, 1.0, null);
    private Set<Voter> voters;
    private VoteCountingResult result;

    public static ListOfVoter newVoter(String voterId, double weight) {
        return ListOfVoter.newVoter(voterId, weight, Sets.newHashSet());
    }

    public static ListOfVoter newVoter(String voterId, double weight, Set<Voter> voters) {
        ListOfVoter result = new ListOfVoter();
        result.setVoterId(voterId);
        result.setWeight(weight);
        result.setVoters(voters);
        return result;
    }

    @Override
    public String getVoterId() {
        return this.rootVoter.getVoterId();
    }

    @Override
    public double getWeight() {
        return this.rootVoter.getWeight();
    }

    @Override
    public Set<VoteForChoice> getVoteForChoices() {
        return this.rootVoter.getVoteForChoices();
    }

    @Override
    public void setVoterId(String voterId) {
        this.rootVoter.setVoterId(voterId);
    }

    @Override
    public void setWeight(double weight) {
        this.rootVoter.setWeight(weight);
    }

    @Override
    public void addVoteForChoice(VoteForChoice voteForChoice) {
        this.getVoteForChoices().add(voteForChoice);
    }

    public Set<Voter> getVoters() {
        if (this.voters == null) {
            this.voters = Sets.newHashSet();
        }
        return this.voters;
    }

    public void addVoter(Voter voter) {
        this.getVoters().add(voter);
    }

    public VoteCountingResult getResult() {
        return this.result;
    }

    public void setVoters(Set<Voter> voters) {
        this.voters = voters;
    }

    public void setResult(VoteCountingResult result) {
        this.result = result;
        this.result.setNbVotants(this.voters.size());
    }

    @Override
    public Iterator<Voter> iterator() {
        return this.getVoters().iterator();
    }
}

