--
-- Création des tables pour le stockage des events & feed
--

CREATE TABLE poll_event (
  topia_id VARCHAR(255) PRIMARY KEY,
  topia_version BIGINT NOT NULL,
  topia_create_date TIMESTAMP WITHOUT TIME ZONE NOT NULL,
  poll VARCHAR(255) REFERENCES poll(topia_id) NOT NULL,
  title TEXT NOT NULL
);

CREATE INDEX IF NOT EXISTS idx_pollevent_poll ON public."poll_event" USING btree (poll);

CREATE TABLE poll_feed (
  topia_id VARCHAR(255) PRIMARY KEY,
  topia_version BIGINT NOT NULL,
  topia_create_date TIMESTAMP WITHOUT TIME ZONE NOT NULL,
  poll VARCHAR(255) REFERENCES poll(topia_id) NOT NULL,
  content LONGVARCHAR NOT NULL
);

CREATE INDEX IF NOT EXISTS idx_pollfeed_poll ON public."poll_feed" USING btree (poll);
