/*
 * #%L
 * Pollen :: Vote Counting
 * $Id: ChoiceType.java 3698 2012-09-23 13:01:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/ChoiceType.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import static org.nuiton.i18n.I18n.n_;

public enum ChoiceType implements I18nAble {
    TEXT(n_("pollen.choiceType.text")),
    DATE(n_("pollen.choiceType.date")),
    IMAGE(n_("pollen.choiceType.image"));

    private final String i18nKey;

    ChoiceType(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    @Override
    public String getI18nKey() {
        return i18nKey;
    }

    public static ChoiceType valueOf(int ordinal) {

        ChoiceType result = null;
        for (ChoiceType curr : ChoiceType.values()) {
            if (curr.ordinal() == ordinal) {
                result = curr;
                break;
            }
        }
        return result;
    }
}
