/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.os;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.TimeoutExecutionException;
import org.arquillian.spacelift.execution.impl.ShutdownHooks;
import org.arquillian.spacelift.task.os.ProcessReference;

public class ProcessBasedExecution<RESULT>
implements Execution<RESULT> {
    private static final Logger log = Logger.getLogger(ProcessBasedExecution.class.getName());
    private final Execution<RESULT> processFutureExecution;
    private final ProcessReference processReference;
    private final String processName;
    private final List<Integer> allowedExitCodes;
    private boolean shouldBeFinished;

    public ProcessBasedExecution(Execution<RESULT> processFutureExecution, ProcessReference processReference, String processName, List<Integer> allowedExitCodes) {
        this.processFutureExecution = processFutureExecution;
        this.processReference = processReference;
        this.processName = processName;
        this.allowedExitCodes = new ArrayList<Integer>(allowedExitCodes);
    }

    public boolean isFinished() {
        if (this.isMarkedAsFinished()) {
            return true;
        }
        try {
            if (!this.processReference.isInitialized()) {
                return false;
            }
            this.processReference.getProcess().exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public boolean isMarkedAsFinished() {
        return this.shouldBeFinished;
    }

    public Execution<RESULT> terminate() throws ExecutionException {
        if (!this.processReference.isInitialized()) {
            this.processFutureExecution.terminate();
            return this.markAsFinished();
        }
        this.processReference.getProcess().destroy();
        try {
            this.processReference.getProcess().waitFor();
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Ignoring Interuption Exception while terminating the process {0}", this.processName);
        }
        OutputStream ostream = this.processReference.getProcess().getOutputStream();
        try {
            if (ostream != null) {
                ostream.flush();
                ostream.close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Ignoring IO exception while terminating the process {0}", this.processName);
        }
        return this;
    }

    public Execution<RESULT> markAsFinished() {
        this.shouldBeFinished = true;
        return this;
    }

    public Execution<RESULT> registerShutdownHook() {
        ShutdownHooks.addHookFor(this);
        return this;
    }

    public boolean hasFailed() {
        if (!this.isFinished()) {
            throw new IllegalStateException("Process " + this.processName + " is not yet finished, cannot determine whether it failed.");
        }
        if (this.allowedExitCodes.isEmpty()) {
            return this.processReference.getProcess().exitValue() != 0;
        }
        return !this.allowedExitCodes.contains(this.processReference.getProcess().exitValue());
    }

    public RESULT await() throws ExecutionException {
        if (this.processFutureExecution.hasFailed()) {
            return null;
        }
        return (RESULT)this.processFutureExecution.await();
    }

    public RESULT awaitAtMost(long timeout, TimeUnit unit) throws ExecutionException, TimeoutExecutionException {
        if (this.processFutureExecution.hasFailed()) {
            return null;
        }
        return (RESULT)this.processFutureExecution.awaitAtMost(timeout, unit);
    }

    public Execution<RESULT> reexecuteEvery(long step, TimeUnit unit) {
        this.processFutureExecution.reexecuteEvery(step, unit);
        return this;
    }

    public RESULT until(long timeout, TimeUnit unit, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        return (RESULT)this.processFutureExecution.until(timeout, unit, condition);
    }

    public RESULT awaitAtMost(CountDownWatch timeout) throws ExecutionException, TimeoutExecutionException {
        return this.awaitAtMost(timeout.timeout(), timeout.getTimeUnit());
    }

    public RESULT until(CountDownWatch timeout, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        return this.until(timeout.timeout(), timeout.getTimeUnit(), condition);
    }
}

