/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.PSRenderer;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSGraphics2DAdapter
implements Graphics2DAdapter {
    private PSGenerator gen;
    private boolean clip = true;

    public PSGraphics2DAdapter(PSRenderer renderer) {
        this(renderer.gen, true);
    }

    public PSGraphics2DAdapter(PSGenerator gen, boolean clip) {
        this.gen = gen;
        this.clip = clip;
    }

    public void paintImage(Graphics2DImagePainter painter, RendererContext context, int x, int y, int width, int height) throws IOException {
        float fwidth = (float)width / 1000.0f;
        float fheight = (float)height / 1000.0f;
        float fx = (float)x / 1000.0f;
        float fy = (float)y / 1000.0f;
        Dimension dim = painter.getImageSize();
        float imw = (float)dim.getWidth() / 1000.0f;
        float imh = (float)dim.getHeight() / 1000.0f;
        float sx = fwidth / imw;
        float sy = fheight / imh;
        this.gen.commentln("%FOPBeginGraphics2D");
        this.gen.saveGraphicsState();
        if (this.clip) {
            this.gen.writeln("newpath");
            this.gen.defineRect((double)fx, (double)fy, (double)fwidth, (double)fheight);
            this.gen.writeln("clip");
        }
        this.gen.concatMatrix((double)sx, 0.0, 0.0, (double)sy, (double)fx, (double)fy);
        boolean textAsShapes = false;
        PSGraphics2D graphics = new PSGraphics2D(false, this.gen);
        graphics.setGraphicContext(new GraphicContext());
        AffineTransform transform = new AffineTransform();
        transform.translate(fx, fy);
        this.gen.getCurrentState().concatMatrix(transform);
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, imw, imh);
        painter.paint((Graphics2D)graphics, (Rectangle2D)area);
        this.gen.restoreGraphicsState();
        this.gen.commentln("%FOPEndGraphics2D");
    }
}

