/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class ColumnSetup {
    private static Log log = LogFactory.getLog((Class)ColumnSetup.class);
    private Table table;
    private List columns = new ArrayList();
    private List colWidths = new ArrayList();
    private int maxColIndexReferenced = 0;

    public ColumnSetup(Table table) {
        this.table = table;
        this.prepareColumns();
        this.initializeColumnWidths();
    }

    private void prepareColumns() {
        List rawCols = this.table.getColumns();
        if (rawCols != null) {
            int colnum = 1;
            ListIterator iter = rawCols.listIterator();
            while (iter.hasNext()) {
                TableColumn col = (TableColumn)iter.next();
                if (col == null) continue;
                colnum = col.getColumnNumber();
                for (int i = 0; i < col.getNumberColumnsRepeated(); ++i) {
                    while (colnum > this.columns.size()) {
                        this.columns.add(null);
                    }
                    this.columns.set(colnum - 1, col);
                    ++colnum;
                }
            }
            int pos = 1;
            ListIterator ppIter = this.columns.listIterator();
            while (ppIter.hasNext()) {
                TableColumn col = (TableColumn)ppIter.next();
                if (col == null) {
                    log.error((Object)("Found a gap in the table-columns at position " + pos));
                }
                ++pos;
            }
        }
    }

    public TableColumn getColumn(int index) {
        int size = this.columns.size();
        if (index > size) {
            if (index > this.maxColIndexReferenced) {
                this.maxColIndexReferenced = index;
                if (size != 1 || !this.getColumn(1).isImplicitColumn()) {
                    log.warn((Object)FONode.decorateWithContextInfo("There are fewer table-columns than are needed. Column " + index + " was accessed, but only " + size + " columns have been defined. " + "The last defined column will be reused.", this.table));
                    if (!this.table.isAutoLayout()) {
                        log.warn((Object)"Please note that according XSL-FO 1.0 (7.26.9) says that the 'column-width' property must be specified for every column, unless the automatic table layout is used.");
                    }
                }
            }
            return (TableColumn)this.columns.get(size - 1);
        }
        return (TableColumn)this.columns.get(index - 1);
    }

    public String toString() {
        return this.columns.toString();
    }

    public int getColumnCount() {
        if (this.maxColIndexReferenced > this.columns.size()) {
            return this.maxColIndexReferenced;
        }
        return this.columns.size();
    }

    public Iterator iterator() {
        return this.columns.iterator();
    }

    private void initializeColumnWidths() {
        int i = this.columns.size();
        while (--i >= 0) {
            if (this.columns.get(i) == null) continue;
            TableColumn col = (TableColumn)this.columns.get(i);
            Length colWidth = col.getColumnWidth();
            this.colWidths.add(0, colWidth);
        }
        this.colWidths.add(0, null);
    }

    protected double computeTableUnit(TableLayoutManager tlm) {
        int sumCols = 0;
        float factors = 0.0f;
        double unit = 0.0;
        Iterator i = this.colWidths.iterator();
        while (i.hasNext()) {
            Length colWidth = (Length)i.next();
            if (colWidth == null) continue;
            sumCols += colWidth.getValue(tlm);
            if (!(colWidth instanceof TableColLength)) continue;
            factors = (float)((double)factors + ((TableColLength)colWidth).getTableUnits());
        }
        if (factors > 0.0f) {
            if (sumCols < tlm.getContentAreaIPD()) {
                unit = (float)(tlm.getContentAreaIPD() - sumCols) / factors;
            } else {
                log.warn((Object)"No space remaining to distribute over columns.");
            }
        }
        return unit;
    }

    public int getXOffset(int col, PercentBaseContext context) {
        int xoffset = 0;
        int i = col;
        while (--i >= 0) {
            int effCol = i < this.colWidths.size() ? i : this.colWidths.size() - 1;
            if (this.colWidths.get(effCol) == null) continue;
            xoffset += ((Length)this.colWidths.get(effCol)).getValue(context);
        }
        return xoffset;
    }

    public int getSumOfColumnWidths(PercentBaseContext context) {
        int sum = 0;
        int c = this.getColumnCount();
        for (int i = 1; i <= c; ++i) {
            int effIndex = i;
            if (i >= this.colWidths.size()) {
                effIndex = this.colWidths.size() - 1;
            }
            if (this.colWidths.get(effIndex) == null) continue;
            sum += ((Length)this.colWidths.get(effIndex)).getValue(context);
        }
        return sum;
    }
}

