/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xbean.finder.MetaAnnotated;
import org.apache.xbean.finder.MetaAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaAnnotatedObject<T>
implements MetaAnnotated<T> {
    protected final Map<Class<? extends Annotation>, MetaAnnotation<?>> annotations = new HashMap();
    protected final T target;

    MetaAnnotatedObject(T target, Map<Class<? extends Annotation>, MetaAnnotation<?>> annotations) {
        this.target = target;
        this.annotations.putAll(annotations);
    }

    @Override
    public T get() {
        return this.target;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        MetaAnnotation<?> annotation = this.annotations.get(annotationClass);
        return annotation == null ? null : (T)annotation.get();
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annotations = new Annotation[this.annotations.size()];
        int i = 0;
        for (MetaAnnotation<?> annotation : this.annotations.values()) {
            annotations[i++] = annotation.get();
        }
        return annotations;
    }

    @Override
    public Collection<MetaAnnotation<?>> getMetaAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    public boolean equals(Object obj) {
        return this.get().equals(obj);
    }

    public int hashCode() {
        return this.get().hashCode();
    }

    public String toString() {
        return this.get().toString();
    }

    private static void unroll(Class<? extends Annotation> clazz, int depth, Map<Class<? extends Annotation>, MetaAnnotation<?>> found) {
        if (!MetaAnnotatedObject.isMetaAnnotation(clazz)) {
            return;
        }
        for (Annotation annotation : MetaAnnotatedObject.getDeclaredMetaAnnotations(clazz)) {
            Class<? extends Annotation> type = annotation.annotationType();
            MetaAnnotation<?> existing = found.get(type);
            if (existing != null) {
                if (existing.getDepth() > depth) {
                    found.put(type, new MetaAnnotation<Annotation>(annotation, depth, clazz));
                    MetaAnnotatedObject.unroll(type, depth + 1, found);
                    continue;
                }
                if (existing.getDepth() < depth) continue;
                existing.getConflicts().add(new MetaAnnotation<Annotation>(annotation, depth, clazz));
                continue;
            }
            found.put(type, new MetaAnnotation<Annotation>(annotation, depth, clazz));
            MetaAnnotatedObject.unroll(type, depth + 1, found);
        }
    }

    private static Collection<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> clazz) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            map.put(annotation.annotationType(), annotation);
        }
        ArrayList<Annotation[]> groups = new ArrayList<Annotation[]>();
        Class<Annotation> metatype = MetaAnnotatedObject.getMetatype(clazz);
        if (metatype != null) {
            try {
                Class<?> def = clazz.getClassLoader().loadClass(clazz.getName() + "$$");
                ArrayList<AccessibleObject> elements = new ArrayList<AccessibleObject>();
                elements.addAll(Arrays.asList(def.getDeclaredFields()));
                elements.addAll(Arrays.asList(def.getDeclaredConstructors()));
                elements.addAll(Arrays.asList(def.getDeclaredMethods()));
                for (Method method : def.getDeclaredMethods()) {
                    for (Annotation[] array : method.getParameterAnnotations()) {
                        groups.add(array);
                    }
                }
                for (Executable executable : def.getDeclaredConstructors()) {
                    for (Annotation[] array : ((Constructor)executable).getParameterAnnotations()) {
                        groups.add(array);
                    }
                }
                for (AnnotatedElement annotatedElement : elements) {
                    groups.add(annotatedElement.getDeclaredAnnotations());
                }
                for (Annotation[] annotationArray : groups) {
                    if (!MetaAnnotatedObject.contains(annotationArray, clazz)) continue;
                    for (Annotation annotation : annotationArray) {
                        map.put(annotation.annotationType(), annotation);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        map.remove(Target.class);
        map.remove(Retention.class);
        map.remove(Documented.class);
        map.remove(metatype);
        map.remove(clazz);
        return map.values();
    }

    private static boolean contains(Annotation[] annotations, Class<? extends Annotation> clazz) {
        for (Annotation annotation : annotations) {
            if (!clazz.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends Annotation> getMetatype(Class<? extends Annotation> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!MetaAnnotatedObject.isMetatypeAnnotation(type)) continue;
            return type;
        }
        return null;
    }

    private static boolean isMetaAnnotation(Class<? extends Annotation> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!MetaAnnotatedObject.isMetatypeAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMetatypeAnnotation(Class<? extends Annotation> type) {
        return type.getSimpleName().equals("Metatype") && type.isAnnotationPresent(type);
    }

    protected static Map<Class<? extends Annotation>, MetaAnnotation<?>> unroll(Class<?> declaringClass, AnnotatedElement element) {
        HashMap map = new HashMap();
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            map.put(annotation.annotationType(), new MetaAnnotation<Annotation>(annotation, 0, declaringClass));
            MetaAnnotatedObject.unroll(annotation.annotationType(), 1, map);
        }
        return map;
    }
}

