/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util.equinox;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.xbean.osgi.bundle.util.BundleResourceHelper;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxBundleResourceHelper
extends BundleResourceHelper {
    private URLConverter converter;

    public EquinoxBundleResourceHelper(Bundle bundle, boolean searchWiredBundles, boolean convertResourceUrls) {
        super(bundle, searchWiredBundles, convertResourceUrls);
        this.init();
    }

    private void init() {
        ServiceReference urlReference;
        BundleContext context = this.bundle.getBundleContext();
        if (context != null && (urlReference = context.getServiceReference(URLConverter.class.getName())) != null) {
            this.converter = (URLConverter)context.getService(urlReference);
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.convertResourceUrls) {
            return this.converter == null ? this.convertedFindResource(name) : this.findResource(name);
        }
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.convertResourceUrls) {
            return this.converter == null ? this.convertedFindResources(name) : this.findResources(name);
        }
        return this.findResources(name);
    }

    @Override
    protected URL convert(URL url) {
        try {
            URL convertedURL = this.converter.resolve(url);
            return convertedURL;
        }
        catch (IOException e) {
            e.printStackTrace();
            return url;
        }
    }
}

