/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaDerivationMethod;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;

public class XmlSchema
extends XmlSchemaAnnotated {
    static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    XmlSchemaForm attributeFormDefault;
    XmlSchemaForm elementFormDefault;
    XmlSchemaObjectTable attributeGroups;
    XmlSchemaObjectTable attributes;
    XmlSchemaObjectTable elements;
    XmlSchemaObjectTable groups;
    XmlSchemaObjectTable notations;
    XmlSchemaObjectTable schemaTypes;
    XmlSchemaDerivationMethod blockDefault;
    XmlSchemaDerivationMethod finalDefault;
    XmlSchemaObjectCollection includes;
    XmlSchemaObjectCollection items;
    boolean isCompiled;
    String targetNamespace = "DEFAULT";
    String version;
    Hashtable namespaces;
    String schema_ns_prefix = "";
    XmlSchemaCollection parent;

    public XmlSchema(XmlSchemaCollection parent) {
        this.parent = parent;
        this.attributeFormDefault = new XmlSchemaForm("unqualified");
        this.elementFormDefault = new XmlSchemaForm("unqualified");
        this.blockDefault = new XmlSchemaDerivationMethod("none");
        this.finalDefault = new XmlSchemaDerivationMethod("none");
        this.items = new XmlSchemaObjectCollection();
        this.includes = new XmlSchemaObjectCollection();
        this.namespaces = new Hashtable();
        this.elements = new XmlSchemaObjectTable();
        this.attributeGroups = new XmlSchemaObjectTable();
        this.attributes = new XmlSchemaObjectTable();
        this.groups = new XmlSchemaObjectTable();
        this.notations = new XmlSchemaObjectTable();
        this.schemaTypes = new XmlSchemaObjectTable();
    }

    public XmlSchema(String namespace, XmlSchemaCollection parent) {
        this(parent);
        this.targetNamespace = namespace;
    }

    protected String getNamespace(String prefix) {
        String ns = (String)this.namespaces.get(prefix);
        if (ns == null) {
            return this.parent.getNamespaceForPrefix(prefix);
        }
        return ns;
    }

    public XmlSchemaForm getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setAttributeFormDefault(XmlSchemaForm value) {
        this.attributeFormDefault = value;
    }

    public XmlSchemaObjectTable getAttributeGroups() {
        return this.attributeGroups;
    }

    public XmlSchemaObjectTable getAttributes() {
        return this.attributes;
    }

    public XmlSchemaDerivationMethod getBlockDefault() {
        return this.blockDefault;
    }

    public void setBlockDefault(XmlSchemaDerivationMethod blockDefault) {
        this.blockDefault = blockDefault;
    }

    public XmlSchemaForm getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(XmlSchemaForm elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public XmlSchemaObjectTable getElements() {
        return this.elements;
    }

    public XmlSchemaElement getElementByName(QName name) {
        return (XmlSchemaElement)this.elements.getItem(name);
    }

    public XmlSchemaType getTypeByName(QName name) {
        return (XmlSchemaType)this.schemaTypes.getItem(name);
    }

    public XmlSchemaDerivationMethod getFinalDefault() {
        return this.finalDefault;
    }

    public void setFinalDefault(XmlSchemaDerivationMethod finalDefault) {
        this.finalDefault = finalDefault;
    }

    public XmlSchemaObjectTable getGroups() {
        return this.groups;
    }

    public XmlSchemaObjectCollection getIncludes() {
        return this.includes;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public XmlSchemaObjectCollection getItems() {
        return this.items;
    }

    public XmlSchemaObjectTable getNotations() {
        return this.notations;
    }

    public XmlSchemaObjectTable getSchemaTypes() {
        return this.schemaTypes;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (!targetNamespace.equals("")) {
            this.targetNamespace = targetNamespace;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void compile(ValidationEventHandler eh) {
    }

    public void write(OutputStream out) {
        this.write(new OutputStreamWriter(out));
    }

    public void write(Writer writer) {
        XmlSchema.serialize_internal(this, writer);
    }

    public Document[] getAllSchemas() {
        try {
            return XmlSchemaSerializer.serializeSchema(this, true);
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    private static void serialize_internal(XmlSchema schema, Writer out) {
        try {
            Document[] serializedSchemas = XmlSchemaSerializer.serializeSchema(schema, false);
            TransformerFactory trFac = TransformerFactory.newInstance();
            DOMSource source = new DOMSource(serializedSchemas[0]);
            StreamResult result = new StreamResult(out);
            Transformer tr = trFac.newTransformer();
            tr.setOutputProperty("omit-xml-declaration", "yes");
            tr.setOutputProperty("indent", "yes");
            tr.transform(source, result);
            out.flush();
        }
        catch (TransformerConfigurationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IOException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    public Hashtable getPrefixToNamespaceMap() {
        return this.namespaces;
    }

    public void setPrefixToNamespaceMap(Hashtable map) {
        this.namespaces = map;
    }

    public void addType(XmlSchemaType type) {
        QName qname = type.getQName();
        if (this.schemaTypes.contains(qname)) {
            throw new RuntimeException("Schema for namespace '" + this.targetNamespace + "' already contains type '" + qname.getLocalPart());
        }
        this.schemaTypes.add(qname, type);
    }
}

