/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.res;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private Locale locale;
    private static Hashtable<String, StringManager> managers = new Hashtable();

    private StringManager(String packageName) {
        block5: {
            String bundleName = packageName + ".LocalStrings";
            try {
                this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
            }
            catch (MissingResourceException ex) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) break block5;
                try {
                    this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
                }
                catch (MissingResourceException ex2) {
                    // empty catch block
                }
            }
        }
        if (this.bundle != null) {
            this.locale = this.bundle.getLocale();
        }
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        String str = null;
        try {
            if (this.bundle != null) {
                str = this.bundle.getString(key);
            }
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public String getString(String key, Object ... args) {
        String value = this.getString(key);
        if (value == null) {
            value = key;
        }
        MessageFormat mf = new MessageFormat(value);
        mf.setLocale(this.locale);
        return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static final synchronized StringManager getManager(String packageName) {
        StringManager mgr = managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }
}

