/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.unsafe.Platform;

public class UnsafeMapData
extends MapData {
    private Object baseObject;
    private long baseOffset;
    private int sizeInBytes;
    private final UnsafeArrayData keys = new UnsafeArrayData();
    private final UnsafeArrayData values = new UnsafeArrayData();

    public Object getBaseObject() {
        return this.baseObject;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void pointTo(Object baseObject, long baseOffset, int sizeInBytes) {
        int keyArraySize = Platform.getInt((Object)baseObject, (long)baseOffset);
        int valueArraySize = sizeInBytes - keyArraySize - 4;
        assert (keyArraySize >= 0) : "keyArraySize (" + keyArraySize + ") should >= 0";
        assert (valueArraySize >= 0) : "valueArraySize (" + valueArraySize + ") should >= 0";
        this.keys.pointTo(baseObject, baseOffset + 4L, keyArraySize);
        this.values.pointTo(baseObject, baseOffset + 4L + (long)keyArraySize, valueArraySize);
        assert (this.keys.numElements() == this.values.numElements());
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public int numElements() {
        return this.keys.numElements();
    }

    @Override
    public UnsafeArrayData keyArray() {
        return this.keys;
    }

    @Override
    public UnsafeArrayData valueArray() {
        return this.values;
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)target, (long)targetOffset, (long)this.sizeInBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.sizeInBytes);
    }

    @Override
    public UnsafeMapData copy() {
        UnsafeMapData mapCopy = new UnsafeMapData();
        byte[] mapDataCopy = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)mapDataCopy, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        mapCopy.pointTo(mapDataCopy, Platform.BYTE_ARRAY_OFFSET, this.sizeInBytes);
        return mapCopy;
    }
}

