/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnSegment
implements ExpressionSegment,
OwnerAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final IdentifierValue identifier;
    private List<IdentifierValue> nestedObjectAttributes;
    private OwnerSegment owner;
    private ColumnSegmentBoundedInfo columnBoundedInfo;
    private ColumnSegmentBoundedInfo otherUsingColumnBoundedInfo;
    private boolean isVariable;
    private List<ParenthesesSegment> parentheses = new LinkedList<ParenthesesSegment>();

    public ColumnSegment(int startIndex, int stopIndex, IdentifierValue identifier) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.columnBoundedInfo = new ColumnSegmentBoundedInfo(identifier);
    }

    public String getQualifiedName() {
        String column = this.identifier.getValueWithQuoteCharacters();
        if (null != this.nestedObjectAttributes && !this.nestedObjectAttributes.isEmpty()) {
            column = String.join((CharSequence)".", column, this.nestedObjectAttributes.stream().map(IdentifierValue::getValueWithQuoteCharacters).collect(Collectors.joining(".")));
        }
        return null == this.owner ? column : String.join((CharSequence)".", this.owner.getIdentifier().getValueWithQuoteCharacters(), column);
    }

    public String getExpression() {
        String column = this.identifier.getValue();
        if (null != this.nestedObjectAttributes && !this.nestedObjectAttributes.isEmpty()) {
            column = String.join((CharSequence)".", column, this.nestedObjectAttributes.stream().map(IdentifierValue::getValue).collect(Collectors.joining(".")));
        }
        return null == this.owner ? column : String.join((CharSequence)".", this.owner.getIdentifier().getValue(), column);
    }

    @Override
    public Optional<OwnerSegment> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public String getText() {
        return this.getExpression();
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public IdentifierValue getIdentifier() {
        return this.identifier;
    }

    @Generated
    public List<IdentifierValue> getNestedObjectAttributes() {
        return this.nestedObjectAttributes;
    }

    @Generated
    public ColumnSegmentBoundedInfo getColumnBoundedInfo() {
        return this.columnBoundedInfo;
    }

    @Generated
    public ColumnSegmentBoundedInfo getOtherUsingColumnBoundedInfo() {
        return this.otherUsingColumnBoundedInfo;
    }

    @Generated
    public boolean isVariable() {
        return this.isVariable;
    }

    @Generated
    public List<ParenthesesSegment> getParentheses() {
        return this.parentheses;
    }

    @Generated
    public void setNestedObjectAttributes(List<IdentifierValue> nestedObjectAttributes) {
        this.nestedObjectAttributes = nestedObjectAttributes;
    }

    @Override
    @Generated
    public void setOwner(OwnerSegment owner) {
        this.owner = owner;
    }

    @Generated
    public void setColumnBoundedInfo(ColumnSegmentBoundedInfo columnBoundedInfo) {
        this.columnBoundedInfo = columnBoundedInfo;
    }

    @Generated
    public void setOtherUsingColumnBoundedInfo(ColumnSegmentBoundedInfo otherUsingColumnBoundedInfo) {
        this.otherUsingColumnBoundedInfo = otherUsingColumnBoundedInfo;
    }

    @Generated
    public void setVariable(boolean isVariable) {
        this.isVariable = isVariable;
    }

    @Generated
    public void setParentheses(List<ParenthesesSegment> parentheses) {
        this.parentheses = parentheses;
    }
}

