/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PowerPointExtractor
extends POIOLE2TextExtractor {
    private HSLFSlideShow _hslfshow;
    private SlideShow _show;
    private Slide[] _slides;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;

    public static void main(String[] args) throws IOException {
        String file;
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean notes = false;
        if (args.length > 1) {
            notes = true;
            file = args[1];
        } else {
            file = args[0];
        }
        PowerPointExtractor ppe = new PowerPointExtractor(file);
        System.out.println(ppe.getText(true, notes));
        ppe.close();
    }

    public PowerPointExtractor(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public PowerPointExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
    }

    public PowerPointExtractor(POIFSFileSystem fs) throws IOException {
        this(new HSLFSlideShow(fs));
    }

    public PowerPointExtractor(HSLFSlideShow ss) throws IOException {
        super((POIDocument)ss);
        this._hslfshow = ss;
        this._show = new SlideShow(this._hslfshow);
        this._slides = this._show.getSlides();
    }

    public void close() throws IOException {
        this._hslfshow.close();
        this._hslfshow = null;
        this._show = null;
        this._slides = null;
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getNotes() {
        return this.getText(false, true);
    }

    public String getText(boolean getSlideText, boolean getNoteText) {
        StringBuffer ret = new StringBuffer();
        if (getSlideText) {
            for (int i = 0; i < this._slides.length; ++i) {
                Slide slide = this._slides[i];
                TextRun[] runs = slide.getTextRuns();
                for (int j = 0; j < runs.length; ++j) {
                    TextRun run = runs[j];
                    if (run == null) continue;
                    String text = run.getText();
                    ret.append(text);
                    if (text.endsWith("\n")) continue;
                    ret.append("\n");
                }
            }
            if (getNoteText) {
                ret.append("\n");
            }
        }
        if (getNoteText) {
            HashSet<Integer> seenNotes = new HashSet<Integer>();
            for (int i = 0; i < this._slides.length; ++i) {
                Integer id;
                Notes notes = this._slides[i].getNotesSheet();
                if (notes == null || seenNotes.contains(id = new Integer(notes._getSheetNumber()))) continue;
                seenNotes.add(id);
                TextRun[] runs = notes.getTextRuns();
                if (runs == null || runs.length <= 0) continue;
                for (int j = 0; j < runs.length; ++j) {
                    TextRun run = runs[j];
                    String text = run.getText();
                    ret.append(text);
                    if (text.endsWith("\n")) continue;
                    ret.append("\n");
                }
            }
        }
        return ret.toString();
    }
}

