/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeNameFinderME
implements TokenNameFinder,
AutoCloseable {
    private final TokenNameFinderModel model;
    private final ThreadLocal<NameFinderME> threadLocal = new ThreadLocal();

    public ThreadSafeNameFinderME(TokenNameFinderModel model) {
        this.model = model;
    }

    private NameFinderME getNameFinder() {
        NameFinderME sd = this.threadLocal.get();
        if (sd == null) {
            sd = new NameFinderME(this.model);
            this.threadLocal.set(sd);
        }
        return sd;
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }

    @Override
    public Span[] find(String[] tokens) {
        return this.getNameFinder().find(tokens);
    }

    @Override
    public void clearAdaptiveData() {
        this.getNameFinder().clearAdaptiveData();
    }
}

