/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.io.IOException;
import opennlp.tools.ml.AbstractTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.DataIndexerFactory;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.HashSumEventStream;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractEventTrainer
extends AbstractTrainer
implements EventTrainer {
    public static final String DATA_INDEXER_PARAM = "DataIndexer";
    public static final String DATA_INDEXER_ONE_PASS_VALUE = "OnePass";
    public static final String DATA_INDEXER_TWO_PASS_VALUE = "TwoPass";
    public static final String DATA_INDEXER_ONE_PASS_REAL_VALUE = "OnePassRealValue";

    public AbstractEventTrainer() {
    }

    public AbstractEventTrainer(TrainingParameters parameters) {
        super(parameters);
    }

    @Override
    public void validate() {
        super.validate();
    }

    public abstract boolean isSortAndMerge();

    public DataIndexer getDataIndexer(ObjectStream<Event> events) throws IOException {
        this.trainingParameters.put("sort", this.isSortAndMerge());
        if (this.trainingParameters.getIntParameter("Cutoff", -1) == -1) {
            this.trainingParameters.put("Cutoff", 5);
        }
        DataIndexer indexer = DataIndexerFactory.getDataIndexer(this.trainingParameters, this.reportMap);
        indexer.index(events);
        return indexer;
    }

    public abstract MaxentModel doTrain(DataIndexer var1) throws IOException;

    @Override
    public final MaxentModel train(DataIndexer indexer) throws IOException {
        this.validate();
        if (indexer.getOutcomeLabels().length <= 1) {
            throw new InsufficientTrainingDataException("Training data must contain more than one outcome");
        }
        MaxentModel model = this.doTrain(indexer);
        this.addToReport("TrainerType", "Event");
        return model;
    }

    @Override
    public final MaxentModel train(ObjectStream<Event> events) throws IOException {
        this.validate();
        HashSumEventStream hses = new HashSumEventStream(events);
        DataIndexer indexer = this.getDataIndexer(hses);
        this.addToReport("Training-Eventhash", hses.calculateHashSum().toString(16));
        return this.train(indexer);
    }
}

