/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;

public class GISModelReader
extends AbstractModelReader {
    public GISModelReader(File file) throws IOException {
        super(file);
    }

    public GISModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        int correctionConstant = this.getCorrectionConstant();
        double correctionParam = this.getCorrectionParameter();
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new GISModel(params, predLabels, outcomeLabels, correctionConstant, correctionParam);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("GIS")) {
            System.out.println("Error: attempting to load a " + modelType + " model as a GIS model. You should expect problems.");
        }
    }

    protected int getCorrectionConstant() throws IOException {
        return this.readInt();
    }

    protected double getCorrectionParameter() throws IOException {
        return this.readDouble();
    }
}

