/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;

public final class TokenNameFinderEvaluatorTool
extends AbstractEvaluatorTool<NameSample, EvalToolParams> {
    public TokenNameFinderEvaluatorTool() {
        super(NameSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the NameFinder model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener detailedFListener = null;
        if (((EvalToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFListener = new TokenNameFinderDetailedFMeasureListener();
            listeners.add(detailedFListener);
        }
        if (((EvalToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((EvalToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model), listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<NameSample> measuredSampleStream = new ObjectStream<NameSample>(){

            @Override
            public NameSample read() throws IOException {
                monitor.incrementCounter();
                return (NameSample)TokenNameFinderEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        if (detailedFListener == null) {
            System.out.println(evaluator.getFMeasure());
        } else {
            System.out.println(detailedFListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
        @ArgumentParser.OptionalParameter
        @ArgumentParser.ParameterDescription(valueName="types", description="name types to use for evaluation")
        public String getNameTypes();
    }
}

