/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class ServicePool
extends ServerServiceFilter {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.SERVICEPOOL, (String)"org.apache.openejb.util.resources");
    private static final int KEEP_ALIVE_TIME = 60000;
    private final ThreadPoolExecutor threadPool;
    private final AtomicBoolean stop = new AtomicBoolean();
    @Managed
    private final Pool pool = new Pool();

    public ServicePool(ServerService next, Properties properties) {
        this(next, new Options(properties).get("threadsCore", 3), new Options(properties).get("threads", 50), new Options(properties).get("queue", 2), new Options(properties).get("block", false), new Options(properties).get("keepAliveTime", 60000));
    }

    public ServicePool(ServerService next, int threads) {
        this(next, threads, threads, threads, true, 60000L);
    }

    public ServicePool(ServerService next, int threads, int queue, boolean block) {
        this(next, threads, threads, queue, block, 60000L);
    }

    public ServicePool(ServerService next, int threadCore, int threads, int queue, final boolean block, long keepAliveTime) {
        super(next);
        if (keepAliveTime <= 0L) {
            keepAliveTime = 60000L;
        }
        if (threadCore <= 0) {
            threadCore = 3;
        }
        if (threads < threadCore) {
            threads = threadCore + 1;
        }
        if (queue >= threadCore) {
            queue = threadCore - 1;
        }
        this.threadPool = new ThreadPoolExecutor(threadCore, threads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queue));
        this.threadPool.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "OpenEJB." + ServicePool.this.getName() + "." + this.i.incrementAndGet());
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        log.error("Uncaught error in: " + t.getName(), e);
                    }
                });
                return t;
            }
        });
        this.threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                if (log.isWarningEnabled()) {
                    log.warning("ServicePool at capicity for process: " + r);
                }
                boolean offer = false;
                try {
                    offer = tpe.getQueue().offer(r, 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!offer) {
                    log.error("ServicePool failed to run asynchronous process: " + r);
                    if (block) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            log.error("ServicePool failed to run synchronous process: " + r);
                        }
                    }
                }
            }
        });
        SystemInstance.get().setComponent(ServicePool.class, (Object)this);
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    @Override
    public void service(final Socket socket) throws ServiceException, IOException {
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Runnable ctxCL = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String msg;
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(tccl);
                    if (ServicePool.this.stop.get()) {
                        return;
                    }
                    ServicePool.super.service(socket);
                }
                catch (SecurityException e) {
                    msg = "ServicePool: Security error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.error(msg, (Throwable)e);
                    } else {
                        log.error(msg + " - Debug for StackTrace");
                    }
                }
                catch (IOException e) {
                    String msg2 = "ServicePool: Unexpected IO error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.debug(msg2, (Throwable)e);
                    } else {
                        log.warning(msg2 + " - Debug for StackTrace");
                    }
                }
                catch (Throwable e) {
                    String msg3 = "ServicePool: Unexpected error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.error(msg3, e);
                    } else {
                        log.error(msg3 + " - Debug for StackTrace");
                    }
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {
                        msg = "ServicePool: Error closing socket";
                        if (log.isDebugEnabled()) {
                            log.debug("ServicePool: Error closing socket", t);
                        }
                        log.warning("ServicePool: Error closing socket");
                    }
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        };
        this.threadPool.execute(ctxCL);
    }

    @Managed(append=true)
    public class Pool {
        @Managed
        public boolean isShutdown() {
            return ServicePool.this.threadPool.isShutdown();
        }

        @Managed
        public boolean isTerminating() {
            return ServicePool.this.threadPool.isTerminating();
        }

        @Managed
        public boolean isTerminated() {
            return ServicePool.this.threadPool.isTerminated();
        }

        @Managed
        public int getPoolSize() {
            return ServicePool.this.threadPool.getPoolSize();
        }

        @Managed
        public int getCorePoolSize() {
            return ServicePool.this.threadPool.getCorePoolSize();
        }

        @Managed
        public int getMaximumPoolSize() {
            return ServicePool.this.threadPool.getMaximumPoolSize();
        }

        @Managed
        public long getKeepAliveTime(TimeUnit unit) {
            return ServicePool.this.threadPool.getKeepAliveTime(unit);
        }

        @Managed
        public int getQueueSize() {
            return ServicePool.this.threadPool.getQueue().size();
        }

        @Managed
        public int getActiveCount() {
            return ServicePool.this.threadPool.getActiveCount();
        }

        @Managed
        public int getLargestPoolSize() {
            return ServicePool.this.threadPool.getLargestPoolSize();
        }

        @Managed
        public long getTaskCount() {
            return ServicePool.this.threadPool.getTaskCount();
        }

        @Managed
        public long getCompletedTaskCount() {
            return ServicePool.this.threadPool.getCompletedTaskCount();
        }

        @Managed
        public void setMaximumPoolSize(int maximumPoolSize) {
            ServicePool.this.threadPool.setMaximumPoolSize(maximumPoolSize);
        }

        @Managed
        public void setCorePoolSize(int corePoolSize) {
            ServicePool.this.getThreadPool().setCorePoolSize(corePoolSize);
        }

        @Managed
        public void allowCoreThreadTimeOut(boolean value) {
            ServicePool.this.getThreadPool().allowCoreThreadTimeOut(value);
        }

        @Managed(description="Sets time in nanoseconds")
        public void setKeepAliveTime(long time) {
            ServicePool.this.getThreadPool().setKeepAliveTime(time, TimeUnit.NANOSECONDS);
        }
    }
}

