/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;

@Managed
public class ServiceDaemon
implements ServerService {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, ServiceDaemon.class);
    @Managed
    private final ServerService next;
    private SocketListener socketListener;
    private int timeout = 0;
    private InetAddress inetAddress;
    private int port;
    private int backlog;
    private String ip;
    private boolean secure;
    private StringTemplate discoveryUriFormat;
    private URI serviceUri;
    private Properties props;
    private String[] enabledCipherSuites;
    @Managed
    private final AddressMonitor address = new AddressMonitor();
    @Managed
    private final SocketMonitor socket = new SocketMonitor();

    public ServiceDaemon(ServerService next) {
        this.next = next;
    }

    public ServiceDaemon(ServerService next, int port, String ip) {
        this.port = port;
        this.ip = ip;
        this.inetAddress = ServiceDaemon.getAddress(ip);
        this.next = next;
    }

    public static InetAddress getAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(host);
        }
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void init(Properties props) throws Exception {
        this.props = props;
        String formatString = props.getProperty("discovery");
        if (formatString != null) {
            this.discoveryUriFormat = new StringTemplate(formatString);
        }
        this.ip = props.getProperty("bind");
        this.inetAddress = ServiceDaemon.getAddress(this.ip);
        Options options = new Options(props);
        this.port = options.get("port", 0);
        int threads = options.get("threads", 100);
        this.backlog = options.get("backlog", threads);
        this.secure = options.get("secure", false);
        this.timeout = options.get("timeout", this.timeout);
        this.enabledCipherSuites = options.get("enabledCipherSuites", "SSL_DH_anon_WITH_RC4_128_MD5").split(",");
        this.next.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            ServerSocket serverSocket;
            if (this.socketListener != null) {
                return;
            }
            this.next.start();
            try {
                if (this.secure) {
                    ServerSocketFactory factory = SSLServerSocketFactory.getDefault();
                    serverSocket = factory.createServerSocket(this.port, this.backlog, this.inetAddress);
                    ((SSLServerSocket)serverSocket).setEnabledCipherSuites(this.enabledCipherSuites);
                } else {
                    serverSocket = new ServerSocket();
                    serverSocket.setReuseAddress(true);
                    serverSocket.bind(new InetSocketAddress(this.inetAddress, this.port), this.backlog);
                }
                serverSocket.setSoTimeout(this.timeout);
                this.port = serverSocket.getLocalPort();
            }
            catch (Exception e) {
                throw new ServiceException("Service failed to open socket", e);
            }
            this.socketListener = new SocketListener(this.next, serverSocket);
            Thread thread = new Thread(this.socketListener);
            thread.setName("service." + this.getName() + "@" + this.socketListener.hashCode());
            thread.setDaemon(true);
            thread.start();
            DiscoveryAgent agent = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
            if (agent != null && this.discoveryUriFormat != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                    map.put(entry.getKey().toString(), entry.getValue().toString());
                }
                map.put("port", Integer.toString(this.port));
                String address = this.ip;
                if ("0.0.0.0".equals(address)) {
                    try {
                        address = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        log.error("Failed to resolve 0.0.0.0 to a routable address", (Throwable)e);
                    }
                }
                map.put("host", address);
                map.put("bind", address);
                String uriString = this.discoveryUriFormat.apply(map);
                try {
                    this.serviceUri = new URI(uriString);
                    agent.registerService(this.serviceUri);
                }
                catch (Exception e) {
                    log.error("Cannot register service '" + this.getName() + "' with DiscoveryAgent.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            DiscoveryAgent agent = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
            if (agent != null && this.discoveryUriFormat != null && this.serviceUri != null) {
                try {
                    agent.unregisterService(this.serviceUri);
                }
                catch (IOException e) {
                    log.error("Cannot unregister service '" + this.getName() + "' with DiscoveryAgent.", (Throwable)e);
                }
            }
            this.next.stop();
            if (this.socketListener != null) {
                this.socketListener.stop();
                this.socketListener = null;
            }
        }
    }

    @Override
    public String getIP() {
        return this.ip;
    }

    @Override
    @Managed
    public int getPort() {
        return this.port;
    }

    @Managed
    public String getBind() {
        return this.ip;
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    @Override
    public String getName() {
        return this.next.getName();
    }

    @Managed
    public URI getServiceUri() {
        return this.serviceUri;
    }

    @Managed
    public boolean isSecure() {
        return this.secure;
    }

    public ServerSocket getServerSocket() {
        return this.socketListener.getServerSocket();
    }

    @Managed(append=true)
    public class SocketMonitor {
        @Managed
        public int getLocalPort() {
            return ServiceDaemon.this.getServerSocket().getLocalPort();
        }

        @Managed
        public boolean getReuseAddress() throws SocketException {
            return ServiceDaemon.this.getServerSocket().getReuseAddress();
        }

        @Managed
        public int getSoTimeout() throws IOException {
            return ServiceDaemon.this.getServerSocket().getSoTimeout();
        }

        @Managed
        public boolean isClosed() {
            return ServiceDaemon.this.getServerSocket().isClosed();
        }

        @Managed
        public boolean isBound() {
            return ServiceDaemon.this.getServerSocket().isBound();
        }

        @Managed
        public int getReceiveBufferSize() throws SocketException {
            return ServiceDaemon.this.getServerSocket().getReceiveBufferSize();
        }

        @Managed
        public void setReceiveBufferSize(int size) throws SocketException {
            ServiceDaemon.this.getServerSocket().setReceiveBufferSize(size);
        }

        @Managed
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            ServiceDaemon.this.getServerSocket().setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        @Managed
        public void setReuseAddress(boolean on) throws SocketException {
            ServiceDaemon.this.getServerSocket().setReuseAddress(on);
        }

        @Managed
        public void setSoTimeout(int timeout) throws SocketException {
            ServiceDaemon.this.getServerSocket().setSoTimeout(timeout);
        }
    }

    @Managed(append=true)
    public class AddressMonitor {
        @Managed
        public String getHostName() {
            return ServiceDaemon.this.inetAddress.getHostName();
        }

        @Managed
        public String getCanonicalHostName() {
            return ServiceDaemon.this.inetAddress.getCanonicalHostName();
        }

        @Managed
        public String getHostAddress() {
            return ServiceDaemon.this.inetAddress.getHostAddress();
        }

        @Managed
        public byte[] getAddress() {
            return ServiceDaemon.this.inetAddress.getAddress();
        }
    }

    private static class SocketListener
    implements Runnable {
        private final ServerService serverService;
        private final ServerSocket serverSocket;
        private AtomicBoolean stop = new AtomicBoolean();
        private Lock lock = new ReentrantLock();

        public SocketListener(ServerService serverService, ServerSocket serverSocket) {
            this.serverService = serverService;
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.stop.set(true);
            boolean b = false;
            try {
                b = this.lock.tryLock(10L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                try {
                    this.serverSocket.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    if (b) {
                        this.lock.unlock();
                    }
                }
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (Throwable e) {
                }
                finally {
                    if (b) {
                        this.lock.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop.get()) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    socket.setSoLinger(true, 10);
                    socket.setTcpNoDelay(true);
                    if (socket.isClosed() || this.stop.get()) continue;
                    try {
                        this.lock.lock();
                        this.serverService.service(socket);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (SocketTimeoutException e) {
                }
                catch (SocketException e) {
                    if (this.stop.get()) continue;
                    log.debug("Socket error", (Throwable)e);
                }
                catch (Throwable e) {
                    if (this.stop.get()) continue;
                    log.debug("Unexpected error", e);
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (Throwable e) {
                log.debug("Error cleaning up socked", e);
            }
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        public int getSoTimeout() throws IOException {
            return this.serverSocket.getSoTimeout();
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }
    }
}

