/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class ServiceLogger
extends ServerServiceFilter {
    private Logger logger;
    private static Method MDBput = null;

    public ServiceLogger(ServerService next) {
        super(next);
    }

    @Override
    public void init(Properties props) throws Exception {
        this.logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("service." + this.getName()), (String)"org.apache.openejb.server.util.resources");
        super.init(props);
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("service(in,out)");
    }

    public static void MDCput(String key, String value) {
        if (MDBput != null) {
            try {
                MDBput.invoke(null, key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
        InetAddress client = socket.getInetAddress();
        ServiceLogger.MDCput("HOST", client.getHostAddress());
        ServiceLogger.MDCput("SERVER", this.getName());
        long start = System.nanoTime();
        try {
            super.service(socket);
            this.logger.debug("[request] " + this.getName() + " " + socket.getPort() + " - " + client.getHostName() + " - " + (System.nanoTime() - start) + "ns");
        }
        catch (Exception e) {
            this.logger.error("[failure] " + socket.getPort() + " - " + client.getHostAddress() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            Class<?> MDC = ServiceLogger.class.getClassLoader().loadClass("org.apache.log4j.MDC");
            MDBput = MDC.getMethod("put", String.class, String.class);
        }
        catch (Exception e) {
            Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)ServiceLogger.class.getName()).info("can't find log4j MDC class");
        }
    }
}

