/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.apache.openejb.loader.BasicURLClassPath;
import sun.misc.URLClassPath;

public class SystemClassPath
extends BasicURLClassPath {
    private URLClassLoader sysLoader;

    public void addJarsToPath(File dir) throws Exception {
        this.addJarsToPath(dir, this.getSystemLoader());
        this.rebuildJavaClassPathVariable();
    }

    public void addJarToPath(URL jar) throws Exception {
        this.addJarToPath(jar, this.getSystemLoader());
        this.rebuildJavaClassPathVariable();
    }

    public ClassLoader getClassLoader() {
        try {
            return this.getSystemLoader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URLClassLoader getSystemLoader() throws Exception {
        if (this.sysLoader == null) {
            this.sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        return this.sysLoader;
    }

    private void rebuildJavaClassPathVariable() throws Exception {
        URLClassPath cp = this.getURLClassPath(this.getSystemLoader());
        URL[] urls = cp.getURLs();
        if (urls.length < 1) {
            return;
        }
        StringBuffer path = new StringBuffer(urls.length * 32);
        File s = new File(URLDecoder.decode(urls[0].getFile()));
        path.append(s.getPath());
        for (int i = 1; i < urls.length; ++i) {
            path.append(File.pathSeparator);
            s = new File(URLDecoder.decode(urls[i].getFile()));
            path.append(s.getPath());
        }
        try {
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

